/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.micronaut;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.build.dependencies.PomDependencyVersionResolver;
import org.grails.forge.feature.Feature;

@Singleton
public class GrailsMicronaut
implements Feature {
    private final PomDependencyVersionResolver versionResolver;

    public GrailsMicronaut(PomDependencyVersionResolver versionResolver) {
        this.versionResolver = versionResolver;
    }

    @Override
    @NonNull
    public String getName() {
        return "grails-micronaut";
    }

    @Override
    public String getTitle() {
        return "Micronaut Support";
    }

    @Override
    public String getDescription() {
        return "Adds support for Micronaut to Grails using the Spring Starter";
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public String getCategory() {
        return "Spring Framework";
    }

    @Override
    public String getDocumentation() {
        return "https://micronaut-projects.github.io/micronaut-spring/latest/guide/#springBootStarter";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-micronaut").implementation());
        Optional<Coordinate> micronautPlatformVersion = this.versionResolver.resolve("micronaut-platform");
        micronautPlatformVersion.ifPresent(coordinate -> generatorContext.getBuildProperties().put("micronautPlatformVersion", coordinate.getVersion()));
    }
}

