/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.view;

import jakarta.inject.Singleton;
import java.util.Set;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.view.GrailsGsp;
import org.grails.forge.options.Options;
import org.grails.forge.util.VersionInfo;

@Singleton
public class Scaffolding
implements DefaultFeature {
    private final GrailsGsp grailsGsp;

    public Scaffolding(GrailsGsp grailsGsp) {
        this.grailsGsp = grailsGsp;
    }

    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.WEB_PLUGIN;
    }

    @Override
    public String getName() {
        return "scaffolding";
    }

    @Override
    public String getTitle() {
        return "Scaffolding";
    }

    @Override
    public String getDescription() {
        return "The Scaffolding Plugin simplifies generating CRUD interfaces for domain classes. It is useful for rapid prototyping and creates basic data management user interfaces with minimal manual code.";
    }

    @Override
    public String getDocumentation() {
        return "https://grails.apache.org/docs/" + VersionInfo.getDocumentationVersion() + "/guide/scaffolding.html";
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return applicationType == ApplicationType.WEB || applicationType == ApplicationType.WEB_PLUGIN;
    }

    @Override
    public void processSelectedFeatures(FeatureContext featureContext) {
        if (!featureContext.isPresent(GrailsGsp.class) && this.grailsGsp != null) {
            featureContext.addFeature(this.grailsGsp);
        }
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("org.fusesource.jansi").artifactId("jansi").runtimeOnly());
        generatorContext.addDependency(Dependency.builder().groupId("org.apache.grails").artifactId("grails-scaffolding").implementation());
    }
}

