/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReplaceOverride
extends MethodOverride {
    private final String methodReplacerBeanName;
    private final List<String> typeIdentifiers = new ArrayList<String>();

    public ReplaceOverride(String methodName, String methodReplacerBeanName) {
        super(methodName);
        Assert.notNull((Object)methodReplacerBeanName, "Method replacer bean name must not be null");
        this.methodReplacerBeanName = methodReplacerBeanName;
    }

    public ReplaceOverride(String methodName, String methodReplacerBeanName, List<String> typeIdentifiers) {
        super(methodName);
        Assert.notNull((Object)methodReplacerBeanName, "Method replacer bean name must not be null");
        this.methodReplacerBeanName = methodReplacerBeanName;
        this.typeIdentifiers.addAll(typeIdentifiers);
    }

    public String getMethodReplacerBeanName() {
        return this.methodReplacerBeanName;
    }

    public void addTypeIdentifier(String identifier) {
        this.typeIdentifiers.add(identifier);
    }

    public List<String> getTypeIdentifiers() {
        return Collections.unmodifiableList(this.typeIdentifiers);
    }

    @Override
    public boolean matches(Method method) {
        if (!method.getName().equals(this.getMethodName())) {
            return false;
        }
        if (!this.isOverloaded()) {
            return true;
        }
        if (this.typeIdentifiers.size() != method.getParameterCount()) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i2 = 0; i2 < this.typeIdentifiers.size(); ++i2) {
            String identifier = this.typeIdentifiers.get(i2);
            if (parameterTypes[i2].getName().contains(identifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        ReplaceOverride that;
        return other instanceof ReplaceOverride && super.equals(that = (ReplaceOverride)other) && this.methodReplacerBeanName.equals(that.methodReplacerBeanName) && this.typeIdentifiers.equals(that.typeIdentifiers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.methodReplacerBeanName, this.typeIdentifiers);
    }

    public String toString() {
        return "ReplaceOverride for method '" + this.getMethodName() + "'";
    }
}

