/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;

public class AntPathMatcher
implements PathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator != null ? pathSeparator : DEFAULT_PATH_SEPARATOR;
    }

    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    @Override
    public boolean matches(String pattern, String source) {
        return this.doMatch(pattern, source, true);
    }

    protected boolean doMatch(String pattern, String path, boolean fullMatch) {
        String patDir;
        int pathIdxStart;
        if (path == null || pattern == null || path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] pattDirs = StringUtils.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathDirs = StringUtils.tokenizeToStringArray(path, this.pathSeparator);
        int pattIdxStart = 0;
        int pattIdxEnd = pattDirs.length - 1;
        int pathIdxEnd = pathDirs.length - 1;
        for (pathIdxStart = 0; pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !"**".equals(patDir = pattDirs[pattIdxStart]); ++pattIdxStart, ++pathIdxStart) {
            if (this.matchStrings(patDir, pathDirs[pathIdxStart])) continue;
            return false;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) ? path.endsWith(this.pathSeparator) : !path.endsWith(this.pathSeparator);
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i2 = pattIdxStart; i2 <= pattIdxEnd; ++i2) {
                if (pattDirs[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (!fullMatch && "**".equals(pattDirs[pattIdxStart])) {
            return true;
        }
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd && !(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd])) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
        }
        if (pathIdxStart > pathIdxEnd) {
            for (int i3 = pattIdxStart; i3 <= pattIdxEnd; ++i3) {
                if (pattDirs[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = pattIdxStart + 1; i4 <= pattIdxEnd; ++i4) {
                if (!pattDirs[i4].equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            int patLength = patIdxTmp - pattIdxStart - 1;
            int strLength = pathIdxEnd - pathIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = pattDirs[pattIdxStart + j + 1];
                    String subStr = pathDirs[pathIdxStart + i5 + j];
                    if (!this.matchStrings(subPat, subStr)) continue block6;
                }
                foundIdx = pathIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
        }
        for (int i6 = pattIdxStart; i6 <= pattIdxEnd; ++i6) {
            if (pattDirs[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean matchStrings(String pattern, String str) {
        char ch;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?' || ch2 == strArr[i2]) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxStart]) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && ch != strArr[strIdxEnd]) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i4 = patIdxStart; i4 <= patIdxEnd; ++i4) {
                if (patArr[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i5 = patIdxStart + 1; i5 <= patIdxEnd; ++i5) {
                if (patArr[i5] != '*') continue;
                patIdxTmp = i5;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i6 = 0; i6 <= strLength - patLength; ++i6) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && ch != strArr[strIdxStart + i6 + j]) continue block8;
                }
                foundIdx = strIdxStart + i6;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i7 = patIdxStart; i7 <= patIdxEnd; ++i7) {
            if (patArr[i7] == '*') continue;
            return false;
        }
        return true;
    }

    public String extractPathWithinPattern(String pattern, String path) {
        int i2;
        String[] patternParts = StringUtils.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathParts = StringUtils.tokenizeToStringArray(path, this.pathSeparator);
        StringBuilder buffer = new StringBuilder();
        int puts = 0;
        for (i2 = 0; i2 < patternParts.length; ++i2) {
            String patternPart = patternParts[i2];
            if (patternPart.indexOf(42) <= -1 && patternPart.indexOf(63) <= -1 || pathParts.length < i2 + 1) continue;
            if (puts > 0 || i2 == 0 && !pattern.startsWith(this.pathSeparator)) {
                buffer.append(this.pathSeparator);
            }
            buffer.append(pathParts[i2]);
            ++puts;
        }
        for (i2 = patternParts.length; i2 < pathParts.length; ++i2) {
            if (puts > 0 || i2 > 0) {
                buffer.append(this.pathSeparator);
            }
            buffer.append(pathParts[i2]);
        }
        return buffer.toString();
    }
}

