/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;

public class ArgumentUtils {
    @NonNull
    public static Number requirePositive(String name, Number value) {
        ArgumentUtils.requireNonNull(name, value);
        ArgumentUtils.requirePositive(name, value.intValue());
        return value;
    }

    public static <T> T requireNonNull(String name, T value) {
        if (value == null) {
            throw new NullPointerException("Argument [" + name + "] cannot be null");
        }
        return value;
    }

    public static int requirePositive(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Argument [" + name + "] cannot be negative");
        }
        return value;
    }

    public static ArgumentCheck check(Check check) {
        return new ArgumentCheck(check);
    }

    public static <T> ArgumentCheck check(String name, T value) {
        return new ArgumentCheck<T>(name, value);
    }

    public static void validateArguments(@NonNull Described described, @NonNull Argument<?>[] arguments, @NonNull Object[] values) {
        int actualCount;
        int requiredCount = arguments.length;
        int n = actualCount = values == null ? 0 : values.length;
        if (requiredCount != actualCount) {
            throw new IllegalArgumentException("Wrong number of arguments to " + (described instanceof Executable ? "method" : "constructor") + ": " + described.getDescription());
        }
        if (requiredCount > 0) {
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                Argument<?> argument = arguments[i2];
                Class<?> type = argument.getWrapperType();
                Object value = values[i2];
                if (value == null || type.isInstance(value)) continue;
                throw new IllegalArgumentException("Invalid type [" + values[i2].getClass().getName() + "] for argument [" + argument + "] of " + (described instanceof Executable ? "method" : "constructor") + ": " + described.getDescription());
            }
        }
    }

    @FunctionalInterface
    public static interface Check {
        public boolean condition();
    }

    public static class ArgumentCheck<T> {
        private final Check check;
        private final String name;
        private final T value;

        public ArgumentCheck(Check check) {
            this.check = check;
            this.name = null;
            this.value = null;
        }

        public ArgumentCheck(String name, T value) {
            this.check = null;
            this.name = name;
            this.value = value;
        }

        public void orElseFail(String message) {
            if (this.check != null && !this.check.condition()) {
                throw new IllegalArgumentException(message);
            }
        }

        public void notNull() {
            if (this.value == null) {
                throw new NullPointerException("Argument [" + this.name + "] cannot be null");
            }
        }
    }
}

