/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.BeanType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class InterceptorBindingQualifier<T>
implements Qualifier<T> {
    public static final String META_MEMBER_MEMBERS = "bindMembers";
    private static final String META_MEMBER_INTERCEPTOR_TYPE = "interceptorType";
    private final Map<String, List<AnnotationValue<?>>> supportedAnnotationNames;
    private final Set<Class<?>> supportedInterceptorTypes;

    InterceptorBindingQualifier(AnnotationMetadata annotationMetadata) {
        List annotationValues = annotationMetadata.findAnnotation("io.micronaut.inject.qualifiers.InterceptorBindingQualifier").map(av -> av.getAnnotations("value")).orElse(Collections.emptyList());
        this.supportedAnnotationNames = new HashMap(annotationValues.size());
        for (AnnotationValue annotationValue : annotationValues) {
            String name = annotationValue.stringValue().orElse(null);
            if (name == null) continue;
            AnnotationValue members = annotationValue.getAnnotation(META_MEMBER_MEMBERS).orElse(null);
            if (members != null) {
                List existing = this.supportedAnnotationNames.computeIfAbsent(name, k -> new ArrayList(5));
                existing.add(members);
                continue;
            }
            this.supportedAnnotationNames.put(name, null);
        }
        this.supportedInterceptorTypes = annotationValues.stream().flatMap(av -> av.classValue(META_MEMBER_INTERCEPTOR_TYPE).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toSet());
    }

    InterceptorBindingQualifier(Collection<AnnotationValue<?>> bindingAnnotations) {
        if (CollectionUtils.isNotEmpty(bindingAnnotations)) {
            this.supportedAnnotationNames = new HashMap(bindingAnnotations.size());
            for (AnnotationValue<?> bindingAnnotation : bindingAnnotations) {
                String name = bindingAnnotation.stringValue().orElse(null);
                if (name == null) continue;
                AnnotationValue members = bindingAnnotation.getAnnotation(META_MEMBER_MEMBERS).orElse(null);
                if (members != null) {
                    List existing = this.supportedAnnotationNames.computeIfAbsent(name, k -> new ArrayList(5));
                    existing.add(members);
                    continue;
                }
                this.supportedAnnotationNames.putIfAbsent(name, null);
            }
        } else {
            this.supportedAnnotationNames = Collections.emptyMap();
        }
        this.supportedInterceptorTypes = Collections.emptySet();
    }

    @Deprecated
    InterceptorBindingQualifier(String[] bindingAnnotations) {
        if (ArrayUtils.isNotEmpty(bindingAnnotations)) {
            this.supportedAnnotationNames = new HashMap(bindingAnnotations.length);
            for (String bindingAnnotation : bindingAnnotations) {
                this.supportedAnnotationNames.put(bindingAnnotation, null);
            }
        } else {
            this.supportedAnnotationNames = Collections.emptyMap();
        }
        this.supportedInterceptorTypes = Collections.emptySet();
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> {
            if (this.supportedInterceptorTypes.contains(candidate.getBeanType())) {
                return true;
            }
            AnnotationMetadata annotationMetadata = candidate.getAnnotationMetadata();
            Collection<AnnotationValue<?>> interceptorValues = InterceptorBindingQualifier.resolveInterceptorAnnotationValues(annotationMetadata, null);
            if (!interceptorValues.isEmpty()) {
                if (interceptorValues.size() == 1) {
                    AnnotationValue<?> interceptorBinding = interceptorValues.iterator().next();
                    String annotationName = interceptorBinding.stringValue().orElse(null);
                    if (annotationName == null) {
                        return false;
                    }
                    List<AnnotationValue<?>> bindingList = this.supportedAnnotationNames.get(annotationName);
                    if (bindingList != null) {
                        AnnotationValue otherBinding = interceptorBinding.getAnnotation(META_MEMBER_MEMBERS).orElse(null);
                        boolean matched = true;
                        for (AnnotationValue<?> binding : bindingList) {
                            matched = matched && (!binding.isPresent(META_MEMBER_MEMBERS) || binding.equals(otherBinding));
                        }
                        return matched;
                    }
                    return this.supportedAnnotationNames.containsKey(annotationName);
                }
                boolean matched = false;
                for (AnnotationValue<?> annotation : interceptorValues) {
                    String annotationName = annotation.stringValue().orElse(null);
                    if (annotationName == null) continue;
                    List<AnnotationValue<?>> bindingList = this.supportedAnnotationNames.get(annotationName);
                    if (bindingList != null) {
                        AnnotationValue<?> binding;
                        AnnotationValue otherBinding = annotation.getAnnotation(META_MEMBER_MEMBERS).orElse(null);
                        Iterator<AnnotationValue<?>> iterator = bindingList.iterator();
                        while (iterator.hasNext() && !(matched = !(binding = iterator.next()).isPresent(META_MEMBER_MEMBERS) || binding.equals(otherBinding))) {
                        }
                    } else {
                        matched = this.supportedAnnotationNames.containsKey(annotationName);
                    }
                    if (!matched) continue;
                    break;
                }
                return matched;
            }
            return false;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorBindingQualifier that = (InterceptorBindingQualifier)o;
        return this.supportedAnnotationNames.equals(that.supportedAnnotationNames) && this.supportedInterceptorTypes.equals(that.supportedInterceptorTypes);
    }

    public int hashCode() {
        return Objects.hash(this.supportedAnnotationNames, this.supportedInterceptorTypes);
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.supportedAnnotationNames) && CollectionUtils.isEmpty(this.supportedInterceptorTypes)) {
            return "@InterceptorBinding(NONE)";
        }
        return this.supportedAnnotationNames.keySet().stream().map(name -> "@InterceptorBinding(" + name + ")").collect(Collectors.joining(" ")) + this.supportedInterceptorTypes.stream().map(name -> "@InterceptorBinding(interceptorType = " + name + ")").collect(Collectors.joining(" "));
    }

    @NonNull
    private static Collection<AnnotationValue<?>> resolveInterceptorAnnotationValues(@NonNull AnnotationMetadata annotationMetadata, @Nullable String kind) {
        List bindings = annotationMetadata.getAnnotationValuesByName("io.micronaut.aop.InterceptorBinding");
        if (CollectionUtils.isNotEmpty(bindings)) {
            return bindings.stream().filter(av -> {
                if (!av.stringValue().isPresent()) {
                    return false;
                }
                if (kind == null) {
                    return true;
                }
                String specifiedkind = av.stringValue("kind").orElse(null);
                return specifiedkind == null || specifiedkind.equals(kind);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

