/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109DomainHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        cookie.setDomain(value);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            throw new CookieRestrictionViolationException("Cookie domain may not be null");
        }
        if (!domain2.equals(host)) {
            int dotIndex = domain2.indexOf(46);
            if (dotIndex == -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" does not match the host \"" + host + "\"");
            }
            if (!domain2.startsWith(".")) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates RFC 2109: domain must start with a dot");
            }
            dotIndex = domain2.indexOf(46, 1);
            if (dotIndex < 0 || dotIndex == domain2.length() - 1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (!(host = host.toLowerCase(Locale.ROOT)).endsWith(domain2)) {
                throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain2 + "\". Domain of origin: \"" + host + "\"");
            }
            String hostWithoutDomain = host.substring(0, host.length() - domain2.length());
            if (hostWithoutDomain.indexOf(46) != -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain2 + "\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            return false;
        }
        return host.equals(domain2) || domain2.startsWith(".") && host.endsWith(domain2);
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

