/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.composition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.composition.DependencyManagementImporter;

@Named
@Singleton
public class DefaultDependencyManagementImporter
implements DependencyManagementImporter {
    @Override
    public void importManagement(Model target, List<? extends DependencyManagement> sources, ModelBuildingRequest request, ModelProblemCollector problems) {
        if (sources != null && !sources.isEmpty()) {
            LinkedHashMap<String, Dependency> dependencies2 = new LinkedHashMap<String, Dependency>();
            DependencyManagement depMgmt = target.getDependencyManagement();
            if (depMgmt != null) {
                for (Dependency dependency : depMgmt.getDependencies()) {
                    dependencies2.put(dependency.getManagementKey(), dependency);
                }
            } else {
                depMgmt = new DependencyManagement();
                target.setDependencyManagement(depMgmt);
            }
            for (DependencyManagement dependencyManagement : sources) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    String key = dependency.getManagementKey();
                    if (dependencies2.containsKey(key)) continue;
                    dependencies2.put(key, dependency);
                }
            }
            depMgmt.setDependencies(new ArrayList<Dependency>(dependencies2.values()));
        }
    }
}

