/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.util;

import org.grails.core.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class BeanCreationProfilingPostProcessor
implements InstantiationAwareBeanPostProcessor,
ApplicationListener<ContextRefreshedEvent> {
    private final StopWatch stopWatch = new StopWatch("Bean Creation StopWatch");
    private static final Logger LOG = LoggerFactory.getLogger("org.grails.startup");

    @Override
    public Object postProcessBeforeInstantiation(@Nullable Class<?> beanClass, @Nullable String beanName) throws BeansException {
        this.stopWatch.start("Create Bean: " + beanName);
        return null;
    }

    @Override
    public Object postProcessAfterInitialization(@Nullable Object bean2, @Nullable String beanName) throws BeansException {
        this.stopWatch.stop();
        return bean2;
    }

    @Override
    public void onApplicationEvent(@NonNull ContextRefreshedEvent event) {
        this.stopWatch.complete();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.stopWatch.prettyPrint());
        }
    }
}

