/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import org.grails.datastore.gorm.validation.constraints.AbstractVetoingConstraint;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class NullableConstraint
extends AbstractVetoingConstraint {
    private final boolean nullable;

    public NullableConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.nullable = (Boolean)this.constraintParameter;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean supports(Class type) {
        return type != null && !type.isPrimitive();
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Boolean)) {
            throw new IllegalArgumentException("Parameter for constraint [nullable] of property [" + this.constraintPropertyName + "] of class [" + String.valueOf(this.constraintOwningClass) + "] must be a boolean value");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "nullable";
    }

    @Override
    protected boolean skipNullValues() {
        return false;
    }

    @Override
    protected boolean processValidateWithVetoing(Object target, Object propertyValue, Errors errors) {
        if (propertyValue == null && !this.nullable) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass};
            this.rejectValue(target, errors, "default.null.message", "nullable", args);
            return true;
        }
        return false;
    }
}

