/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.model.types;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;

public class BasicTypeConverterRegistrar {
    public void register(ConverterRegistry registry) {
        registry.addConverter(new Converter<Class, String>(){

            @Override
            public String convert(Class aClass) {
                return aClass.getName();
            }
        });
        registry.addConverter(new Converter<Date, String>(){

            @Override
            public String convert(Date date) {
                return String.valueOf(date.getTime());
            }
        });
        registry.addConverter(new Converter<Date, Calendar>(){

            @Override
            public Calendar convert(Date date) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(date);
                return calendar;
            }
        });
        registry.addConverter(new Converter<Integer, Long>(){

            @Override
            public Long convert(Integer integer) {
                return integer.longValue();
            }
        });
        registry.addConverter(new Converter<Long, Integer>(){

            @Override
            public Integer convert(Long longValue) {
                return longValue.intValue();
            }
        });
        registry.addConverter(new Converter<Integer, Double>(){

            @Override
            public Double convert(Integer integer) {
                return integer.doubleValue();
            }
        });
        registry.addConverter(new Converter<CharSequence, Date>(){

            @Override
            public Date convert(CharSequence s) {
                try {
                    Long time = Long.valueOf(s.toString());
                    return new Date(time);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter(new Converter<CharSequence, Double>(){

            @Override
            public Double convert(CharSequence s) {
                try {
                    return Double.valueOf(s.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter(new Converter<CharSequence, Integer>(){

            @Override
            public Integer convert(CharSequence s) {
                try {
                    return Integer.valueOf(s.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter(new Converter<CharSequence, Long>(){

            @Override
            public Long convert(CharSequence s) {
                try {
                    return Long.valueOf(s.toString());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        registry.addConverter(new Converter<Object, String>(){

            @Override
            public String convert(Object o) {
                return o.toString();
            }
        });
        registry.addConverter(new Converter<Calendar, String>(){

            @Override
            public String convert(Calendar calendar) {
                return String.valueOf(calendar.getTime().getTime());
            }
        });
        registry.addConverter(new Converter<CharSequence, Calendar>(){

            @Override
            public Calendar convert(CharSequence s) {
                try {
                    Date date = new Date(Long.valueOf(s.toString()));
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTime(date);
                    return c;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }
}

