/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.encoder.AbstractCharReplacementEncoder;
import org.grails.encoder.CodecIdentifier;
import org.grails.encoder.DefaultCodecIdentifier;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.HtmlUtils;

public class HTML4Encoder
extends AbstractCharReplacementEncoder {
    private static final Log log = LogFactory.getLog(HTML4Encoder.class);
    static final String HTML4_CODEC_NAME = "HTML4";
    static final CodecIdentifier HTML4_CODEC_IDENTIFIER = new DefaultCodecIdentifier("HTML4");
    Map<Character, String> replacements = new ConcurrentHashMap<Character, String>();
    private static final String NULL_MARKER = "NULL_MARKER";

    public HTML4Encoder() {
        super(HTML4_CODEC_IDENTIFIER);
    }

    @Override
    protected String escapeCharacter(char ch, char previousChar) {
        Character key = Character.valueOf(ch);
        String replacement = this.replacements.get(key);
        if (replacement == null) {
            replacement = StreamingHTMLEncoderHelper.convertToReference(ch);
            this.replacements.put(key, replacement != null ? replacement : NULL_MARKER);
        }
        return replacement != NULL_MARKER ? replacement : null;
    }

    private static final class StreamingHTMLEncoderHelper {
        private static Object instance;
        private static Method mapMethod;
        private static boolean disabled;

        private StreamingHTMLEncoderHelper() {
        }

        public static final String convertToReference(char c) {
            String replacement;
            if (!disabled) {
                return (String)ReflectionUtils.invokeMethod(mapMethod, instance, Character.valueOf(c));
            }
            String charAsString = String.valueOf(c);
            if (charAsString.equals(replacement = HtmlUtils.htmlEscape(charAsString))) {
                return null;
            }
            return replacement;
        }

        static {
            disabled = false;
            try {
                Field instanceField = ReflectionUtils.findField(HtmlUtils.class, "characterEntityReferences");
                ReflectionUtils.makeAccessible(instanceField);
                instance = instanceField.get(null);
                mapMethod = ReflectionUtils.findMethod(instance.getClass(), "convertToReference", Character.TYPE);
                if (mapMethod != null) {
                    ReflectionUtils.makeAccessible(mapMethod);
                }
            }
            catch (Exception e) {
                log.warn("Couldn't use reflection for resolving characterEntityReferences in HtmlUtils class", e);
                disabled = true;
            }
        }
    }
}

