/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.application.Project;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.application.generator.ProjectGenerator;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.MapOutputHandler;
import org.grails.forge.options.Options;

@Singleton
public class FeatureDiffer {
    public void produceDiff(ProjectGenerator projectGenerator, Project project, ApplicationType applicationType, Options options, @Nullable OperatingSystem operatingSystem, List<String> features, ConsoleOutput consoleOutput) throws Exception {
        GeneratorContext generatorContext = projectGenerator.createGeneratorContext(applicationType, project, options, operatingSystem, features, consoleOutput);
        this.produceDiff(projectGenerator, generatorContext, consoleOutput);
    }

    public void produceDiff(ProjectGenerator projectGenerator, GeneratorContext generatorContext, ConsoleOutput consoleOutput) throws Exception {
        MapOutputHandler outputHandler = new MapOutputHandler();
        Project project = generatorContext.getProject();
        ApplicationType applicationType = generatorContext.getApplicationType();
        projectGenerator.generate(applicationType, project, new Options(generatorContext.getTestFramework(), generatorContext.getJdkVersion()), generatorContext.getOperatingSystem(), Collections.emptyList(), outputHandler, ConsoleOutput.NOOP);
        Map<String, String> oldProject = outputHandler.getProject();
        outputHandler = new MapOutputHandler();
        projectGenerator.generate(applicationType, project, outputHandler, generatorContext);
        Map<String, String> newProject = outputHandler.getProject();
        for (Map.Entry<String, String> entry : newProject.entrySet()) {
            String oldFile = oldProject.remove(entry.getKey());
            if (entry.getValue() == null) continue;
            List<String> oldFileLines = oldFile == null ? Collections.emptyList() : this.toLines(oldFile);
            String newFile = entry.getValue();
            List<String> newFileLines = this.toLines(newFile);
            Patch<String> diff = DiffUtils.diff(oldFileLines, newFileLines);
            List<String> unifiedDiff = UnifiedDiffUtils.generateUnifiedDiff(entry.getKey(), entry.getKey(), oldFileLines, diff, 3);
            if (unifiedDiff.isEmpty()) continue;
            for (String delta : unifiedDiff) {
                if (delta.startsWith("+")) {
                    consoleOutput.green(delta);
                    continue;
                }
                if (delta.startsWith("-")) {
                    consoleOutput.red(delta);
                    continue;
                }
                consoleOutput.out(delta);
            }
            consoleOutput.out("\n");
        }
        for (Map.Entry<String, String> entry : oldProject.entrySet()) {
            if (entry.getValue() == null) continue;
            List<String> oldFileLines = this.toLines(entry.getValue());
            Patch<String> diff = DiffUtils.diff(oldFileLines, Collections.emptyList());
            List<String> unifiedDiff = UnifiedDiffUtils.generateUnifiedDiff(entry.getKey(), entry.getKey(), oldFileLines, diff, 3);
            if (unifiedDiff.isEmpty()) continue;
            for (String delta : unifiedDiff) {
                if (delta.startsWith("+")) {
                    consoleOutput.green(delta);
                    continue;
                }
                if (delta.startsWith("-")) {
                    consoleOutput.red(delta);
                    continue;
                }
                consoleOutput.out(delta);
            }
            consoleOutput.out("\n");
        }
    }

    private List<String> toLines(String file) {
        return Arrays.asList(file.split("\n"));
    }
}

