/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import org.grails.forge.application.Project;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.io.OutputUtils;
import org.grails.forge.template.Template;
import org.grails.forge.template.Writable;

public class FileSystemOutputHandler
implements OutputHandler {
    File applicationDirectory;
    private final ConsoleOutput console;
    private final Instant lastModified;

    public FileSystemOutputHandler(Project project, boolean inplace, ConsoleOutput console) throws IOException {
        this.console = console;
        File baseDirectory = FileSystemOutputHandler.getDefaultBaseDirectory();
        this.applicationDirectory = inplace ? baseDirectory : new File(baseDirectory, project.getName()).getCanonicalFile();
        if (this.applicationDirectory.exists() && !inplace) {
            throw new IllegalArgumentException("Cannot create the project because the target directory already exists");
        }
        this.lastModified = OutputUtils.createLastModified(null);
    }

    public FileSystemOutputHandler(File directory, ConsoleOutput console) throws IOException {
        this.console = console;
        this.applicationDirectory = directory;
        this.lastModified = OutputUtils.createLastModified(null);
    }

    public static File getDefaultBaseDirectory() throws IOException {
        String userDir = System.getProperty("user.dir");
        return new File(Objects.requireNonNullElse(userDir, "")).getCanonicalFile();
    }

    @Override
    public String getOutputLocation() {
        return this.applicationDirectory.getAbsolutePath();
    }

    @Override
    public boolean exists(String path) {
        return new File(this.applicationDirectory, path).exists();
    }

    @Override
    public void write(String path, Template contents) throws IOException {
        File targetFile = this.write(path, (Writable)contents);
        if (contents.isExecutable() && !targetFile.setExecutable(true, true)) {
            this.console.warning("Failed to set " + path + " to be executable");
        }
    }

    public File write(String path, Writable contents) throws IOException {
        if ('/' != File.separatorChar) {
            path = path.replace('/', File.separatorChar);
        }
        File targetFile = new File(this.applicationDirectory, path);
        Path base = this.applicationDirectory.toPath().toAbsolutePath().normalize();
        Path parent = targetFile.getParentFile().toPath().toAbsolutePath().normalize();
        ArrayList<Path> createdDirs = new ArrayList<Path>();
        if (!parent.startsWith(base)) {
            throw new IOException("Refusing to write outside base directory: " + String.valueOf(parent));
        }
        Path p = base;
        for (Path seg : base.relativize(parent)) {
            if (!Files.notExists(p = p.resolve(seg), new LinkOption[0])) continue;
            createdDirs.add(p);
        }
        Files.createDirectories(parent, new FileAttribute[0]);
        Files.deleteIfExists(targetFile.toPath());
        try (OutputStream os = Files.newOutputStream(targetFile.toPath(), new OpenOption[0]);){
            contents.write(os);
        }
        if (this.lastModified != null) {
            FileTime mtime = FileTime.from(this.lastModified);
            Files.setLastModifiedTime(targetFile.toPath(), mtime);
            for (int i2 = createdDirs.size() - 1; i2 >= 0; --i2) {
                try {
                    Files.setLastModifiedTime((Path)createdDirs.get(i2), mtime);
                    continue;
                }
                catch (IOException ignore) {
                    this.console.warning("Could not set mtime for dir: " + String.valueOf(createdDirs.get(i2)));
                }
            }
        }
        return targetFile;
    }

    @Override
    public void close() {
    }
}

