/*
 * Decompiled with CFR 0.152.
 */
package org.grails.io.watch;

import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.io.watch.AbstractDirectoryWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacOsWatchServiceDirectoryWatcher
extends AbstractDirectoryWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(MacOsWatchServiceDirectoryWatcher.class);
    private Map<WatchKey, List<String>> watchKeyToExtensionsMap = new ConcurrentHashMap<WatchKey, List<String>>();
    private Set<Path> individualWatchedFiles = new HashSet<Path>();
    private final WatchService watchService;

    private static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    public MacOsWatchServiceDirectoryWatcher() {
        try {
            this.watchService = new MacOSXListeningWatchService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        while (this.active) {
            try {
                WatchKey watchKey;
                try {
                    watchKey = this.watchService.take();
                }
                catch (InterruptedException x) {
                    return;
                }
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        LOG.warn("WatchService Overflow occurred");
                        continue;
                    }
                    WatchEvent pathWatchEvent = MacOsWatchServiceDirectoryWatcher.cast(watchEvent);
                    Path child = (Path)pathWatchEvent.context();
                    File childFile = child.toFile();
                    if (this.individualWatchedFiles.contains(child) || this.individualWatchedFiles.contains(child.normalize())) {
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                            this.fireOnNew(childFile);
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                            this.fireOnChange(childFile);
                            continue;
                        }
                        if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        continue;
                    }
                    List<String> fileExtensions = this.watchKeyToExtensionsMap.get(watchKey);
                    if (fileExtensions == null) {
                        LOG.debug("WatchService received an event for a file/directory that it's not interested in.");
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        File[] files;
                        this.addWatchDirectory(child, fileExtensions);
                        if (childFile.isDirectory() && childFile.exists() && (files = childFile.listFiles()) != null) {
                            for (File newFile : files) {
                                if (!this.isValidFileToMonitor(newFile, fileExtensions)) continue;
                                this.fireOnNew(newFile);
                            }
                        }
                    }
                    if (!this.isValidFileToMonitor(childFile, fileExtensions)) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.fireOnNew(childFile);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.fireOnChange(childFile);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                }
                watchKey.reset();
            }
            catch (Exception e) {
                LOG.error(e.toString());
            }
        }
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            LOG.debug("Exception while closing watchService", e);
        }
    }

    @Override
    public void addWatchFile(File fileToWatch) {
        if (!this.isValidFileToMonitor(fileToWatch, Arrays.asList("*"))) {
            return;
        }
        try {
            if (!fileToWatch.exists()) {
                return;
            }
            Path pathToWatch = fileToWatch.toPath().toAbsolutePath();
            this.individualWatchedFiles.add(pathToWatch);
            WatchablePath watchPath = new WatchablePath(pathToWatch);
            WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            watchPath.register(this.watchService, events);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addWatchDirectory(File dir, List<String> fileExtensions) {
        Path dirPath = dir.toPath();
        this.addWatchDirectory(dirPath, fileExtensions);
    }

    private void addWatchDirectory(Path dir, final List<String> fileExtensions) {
        if (!this.isValidDirectoryToMonitor(dir.toFile())) {
            return;
        }
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!MacOsWatchServiceDirectoryWatcher.this.isValidDirectoryToMonitor(dir.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    WatchablePath watchPath = new WatchablePath(dir);
                    WatchEvent.Kind[] events = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                    WatchKey watchKey = watchPath.register(MacOsWatchServiceDirectoryWatcher.this.watchService, events);
                    List<String> originalFileExtensions = MacOsWatchServiceDirectoryWatcher.this.watchKeyToExtensionsMap.get(watchKey);
                    if (originalFileExtensions == null) {
                        MacOsWatchServiceDirectoryWatcher.this.watchKeyToExtensionsMap.put(watchKey, fileExtensions);
                    } else {
                        HashSet<String> newFileExtensions = new HashSet<String>(originalFileExtensions);
                        newFileExtensions.addAll(fileExtensions);
                        MacOsWatchServiceDirectoryWatcher.this.watchKeyToExtensionsMap.put(watchKey, Collections.unmodifiableList(new ArrayList<String>(newFileExtensions)));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

