/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.web.mapping;

import grails.util.Environment;
import grails.web.CamelCaseUrlConverter;
import grails.web.HyphenatedUrlConverter;
import grails.web.UrlConverter;
import grails.web.mapping.LinkGenerator;
import grails.web.mapping.UrlMappings;
import grails.web.mapping.cors.GrailsCorsConfiguration;
import grails.web.mapping.cors.GrailsCorsFilter;
import org.grails.web.mapping.CachingLinkGenerator;
import org.grails.web.mapping.DefaultLinkGenerator;
import org.grails.web.mapping.mvc.UrlMappingsInfoHandlerAdapter;
import org.grails.web.mapping.servlet.UrlMappingsErrorPageCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={GrailsCorsConfiguration.class})
public class UrlMappingsAutoConfiguration {
    @Value(value="${grails.web.linkGenerator.useCache:#{null}}")
    private Boolean cacheUrls;
    @Value(value="${grails.serverURL:#{null}}")
    private String serverURL;

    @Bean(value={"grailsUrlConverter"})
    @ConditionalOnMissingBean(name={"grailsUrlConverter"})
    @ConditionalOnProperty(name={"grails.web.url.converter"}, havingValue="camelCase", matchIfMissing=true)
    public UrlConverter camelCaseUrlConverter() {
        return new CamelCaseUrlConverter();
    }

    @Bean(value={"grailsUrlConverter"})
    @ConditionalOnMissingBean(name={"grailsUrlConverter"})
    @ConditionalOnProperty(name={"grails.web.url.converter"}, havingValue="hyphenated")
    public UrlConverter hyphenatedUrlConverter() {
        return new HyphenatedUrlConverter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"grailsLinkGenerator"})
    public LinkGenerator grailsLinkGenerator() {
        if (this.cacheUrls == null) {
            this.cacheUrls = !Environment.isDevelopmentMode() && !Environment.getCurrent().isReloadEnabled();
        }
        return this.cacheUrls != false ? new CachingLinkGenerator(this.serverURL) : new DefaultLinkGenerator(this.serverURL);
    }

    @Bean
    @ConditionalOnProperty(name={"grails.cors.filter"}, havingValue="true", matchIfMissing=true)
    public GrailsCorsFilter grailsCorsFilter(GrailsCorsConfiguration grailsCorsConfiguration) {
        return new GrailsCorsFilter(grailsCorsConfiguration);
    }

    @Bean
    public UrlMappingsErrorPageCustomizer urlMappingsErrorPageCustomizer(ObjectProvider<UrlMappings> urlMappingsProvider) {
        UrlMappingsErrorPageCustomizer errorPageCustomizer = new UrlMappingsErrorPageCustomizer();
        errorPageCustomizer.setUrlMappings(urlMappingsProvider.getIfAvailable());
        return errorPageCustomizer;
    }

    @Bean
    public UrlMappingsInfoHandlerAdapter urlMappingsInfoHandlerAdapter() {
        return new UrlMappingsInfoHandlerAdapter();
    }
}

