/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ldap;

import java.util.Collections;
import java.util.Locale;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ldap.LdapConnectionDetails;
import org.springframework.boot.autoconfigure.ldap.LdapProperties;
import org.springframework.boot.autoconfigure.ldap.PropertiesLdapConnectionDetails;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.env.Environment;
import org.springframework.ldap.convert.ConverterUtils;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DirContextAuthenticationStrategy;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.odm.core.impl.DefaultObjectDirectoryMapper;

@AutoConfiguration
@ConditionalOnClass(value={ContextSource.class})
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={LdapConnectionDetails.class})
    PropertiesLdapConnectionDetails propertiesLdapConnectionDetails(LdapProperties properties, Environment environment2) {
        return new PropertiesLdapConnectionDetails(properties, environment2);
    }

    @Bean
    @ConditionalOnMissingBean
    public LdapContextSource ldapContextSource(LdapConnectionDetails connectionDetails, LdapProperties properties, ObjectProvider<DirContextAuthenticationStrategy> dirContextAuthenticationStrategy) {
        LdapContextSource source = new LdapContextSource();
        dirContextAuthenticationStrategy.ifUnique(arg_0 -> ((LdapContextSource)source).setAuthenticationStrategy(arg_0));
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from(connectionDetails.getUsername()).to(arg_0 -> ((LdapContextSource)source).setUserDn(arg_0));
        propertyMapper.from(connectionDetails.getPassword()).to(arg_0 -> ((LdapContextSource)source).setPassword(arg_0));
        propertyMapper.from(properties.getAnonymousReadOnly()).to(arg_0 -> ((LdapContextSource)source).setAnonymousReadOnly(arg_0));
        propertyMapper.from(properties.getReferral()).as(referral -> referral.name().toLowerCase(Locale.ROOT)).to(arg_0 -> ((LdapContextSource)source).setReferral(arg_0));
        propertyMapper.from(connectionDetails.getBase()).to(arg_0 -> ((LdapContextSource)source).setBase(arg_0));
        propertyMapper.from(connectionDetails.getUrls()).to(arg_0 -> ((LdapContextSource)source).setUrls(arg_0));
        propertyMapper.from(properties.getBaseEnvironment()).to(baseEnvironment -> source.setBaseEnvironmentProperties(Collections.unmodifiableMap(baseEnvironment)));
        return source;
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectDirectoryMapper objectDirectoryMapper() {
        ApplicationConversionService conversionService = new ApplicationConversionService();
        ConverterUtils.addDefaultConverters((ConverterRegistry)conversionService);
        DefaultObjectDirectoryMapper objectDirectoryMapper = new DefaultObjectDirectoryMapper();
        objectDirectoryMapper.setConversionService((ConversionService)conversionService);
        return objectDirectoryMapper;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapOperations.class})
    public LdapTemplate ldapTemplate(LdapProperties properties, ContextSource contextSource, ObjectDirectoryMapper objectDirectoryMapper) {
        LdapProperties.Template template = properties.getTemplate();
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        LdapTemplate ldapTemplate = new LdapTemplate(contextSource);
        ldapTemplate.setObjectDirectoryMapper(objectDirectoryMapper);
        propertyMapper.from(template.isIgnorePartialResultException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnorePartialResultException(arg_0));
        propertyMapper.from(template.isIgnoreNameNotFoundException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreNameNotFoundException(arg_0));
        propertyMapper.from(template.isIgnoreSizeLimitExceededException()).to(arg_0 -> ((LdapTemplate)ldapTemplate).setIgnoreSizeLimitExceededException(arg_0));
        return ldapTemplate;
    }
}

