/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.http.HttpClient;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.JdkHttpClientBuilder;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JdkClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<JdkClientHttpRequestFactory> {
    private final JdkHttpClientBuilder httpClientBuilder;

    JdkClientHttpRequestFactoryBuilder() {
        this(null, new JdkHttpClientBuilder());
    }

    private JdkClientHttpRequestFactoryBuilder(List<Consumer<JdkClientHttpRequestFactory>> customizers, JdkHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public JdkClientHttpRequestFactoryBuilder withCustomizer(Consumer<JdkClientHttpRequestFactory> customizer2) {
        return new JdkClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer2), this.httpClientBuilder);
    }

    public JdkClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<JdkClientHttpRequestFactory>> customizers) {
        return new JdkClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public JdkClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClient.Builder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, "'httpClientCustomizer' must not be null");
        return new JdkClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    @Override
    protected JdkClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings.withReadTimeout(null)));
        JdkClientHttpRequestFactory requestFactory = new JdkClientHttpRequestFactory(httpClient);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::readTimeout).to(requestFactory::setReadTimeout);
        return requestFactory;
    }

    static class Classes {
        static final String HTTP_CLIENT = "java.net.http.HttpClient";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent(HTTP_CLIENT, classLoader);
        }
    }
}

