/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.loader.tools.LaunchScript;

public class DefaultLaunchScript
implements LaunchScript {
    private static final int BUFFER_SIZE = 4096;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{\\{(\\w+)(:.*?)?}}(?!})");
    private static final Set<String> FILE_PATH_KEYS = Collections.singleton("inlinedConfScript");
    private final String content;

    public DefaultLaunchScript(File file, Map<?, ?> properties) throws IOException {
        String content = this.loadContent(file);
        this.content = this.expandPlaceholders(content, properties);
    }

    private String loadContent(File file) throws IOException {
        if (file == null) {
            return this.loadContent(this.getClass().getResourceAsStream("launch.script"));
        }
        return this.loadContent(new FileInputStream(file));
    }

    private String loadContent(InputStream inputStream) throws IOException {
        try (InputStream inputStream2 = inputStream;){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.copy(inputStream, outputStream);
            String string = outputStream.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
    }

    private String expandPlaceholders(String content, Map<?, ?> properties) throws IOException {
        StringBuilder expanded = new StringBuilder();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(content);
        while (matcher.find()) {
            String value;
            String name = matcher.group(1);
            String defaultValue = matcher.group(2);
            if (properties != null && properties.containsKey(name)) {
                Object propertyValue = properties.get(name);
                value = FILE_PATH_KEYS.contains(name) ? this.parseFilePropertyValue(propertyValue) : propertyValue.toString();
            } else {
                value = defaultValue != null ? defaultValue.substring(1) : matcher.group(0);
            }
            matcher.appendReplacement(expanded, value.replace("$", "\\$"));
        }
        matcher.appendTail(expanded);
        return expanded.toString();
    }

    private String parseFilePropertyValue(Object propertyValue) throws IOException {
        if (propertyValue instanceof File) {
            File file = (File)propertyValue;
            return this.loadContent(file);
        }
        return this.loadContent(new File(propertyValue.toString()));
    }

    @Override
    public byte[] toByteArray() {
        return this.content.getBytes(StandardCharsets.UTF_8);
    }
}

