/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import io.netty.handler.ssl.ClientAuth;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Ssl;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.server.HttpServer;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;
import reactor.netty.tcp.SslProvider;

public class SslServerCustomizer
implements NettyServerCustomizer {
    private static final Log logger = LogFactory.getLog(SslServerCustomizer.class);
    private final Http2 http2;
    private final ClientAuth clientAuth;
    private volatile SslProvider sslProvider;
    private final Map<String, SslProvider> serverNameSslProviders;

    public SslServerCustomizer(Http2 http2, Ssl.ClientAuth clientAuth, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        this.http2 = http2;
        this.clientAuth = Ssl.ClientAuth.map(clientAuth, ClientAuth.NONE, ClientAuth.OPTIONAL, ClientAuth.REQUIRE);
        this.sslProvider = this.createSslProvider(sslBundle);
        this.serverNameSslProviders = this.createServerNameSslProviders(serverNameSslBundles);
        this.updateSslBundle(null, sslBundle);
    }

    @Override
    public HttpServer apply(HttpServer server) {
        return server.secure(this::applySecurity);
    }

    private void applySecurity(SslProvider.SslContextSpec spec) {
        spec.sslContext(this.sslProvider.getSslContext()).setSniAsyncMappings((serverName, promise) -> {
            SslProvider provider = serverName != null ? this.serverNameSslProviders.get(serverName) : this.sslProvider;
            return promise.setSuccess(provider);
        });
    }

    void updateSslBundle(String serverName, SslBundle sslBundle) {
        logger.debug("SSL Bundle has been updated, reloading SSL configuration");
        if (serverName == null) {
            this.sslProvider = this.createSslProvider(sslBundle);
        } else {
            this.serverNameSslProviders.put(serverName, this.createSslProvider(sslBundle));
        }
    }

    private Map<String, SslProvider> createServerNameSslProviders(Map<String, SslBundle> serverNameSslBundles) {
        HashMap<String, SslProvider> serverNameSslProviders = new HashMap<String, SslProvider>();
        serverNameSslBundles.forEach((serverName, sslBundle) -> serverNameSslProviders.put((String)serverName, this.createSslProvider((SslBundle)sslBundle)));
        return serverNameSslProviders;
    }

    private SslProvider createSslProvider(SslBundle sslBundle) {
        return SslProvider.builder().sslContext(this.createSslContextSpec(sslBundle)).build();
    }

    protected final AbstractProtocolSslContextSpec<?> createSslContextSpec(SslBundle sslBundle) {
        Http11SslContextSpec sslContextSpec = this.http2 != null && this.http2.isEnabled() ? Http2SslContextSpec.forServer((KeyManagerFactory)sslBundle.getManagers().getKeyManagerFactory()) : Http11SslContextSpec.forServer((KeyManagerFactory)sslBundle.getManagers().getKeyManagerFactory());
        return sslContextSpec.configure(builder -> {
            builder.trustManager(sslBundle.getManagers().getTrustManagerFactory());
            SslOptions options = sslBundle.getOptions();
            builder.protocols(options.getEnabledProtocols());
            builder.ciphers(SslOptions.asSet(options.getCiphers()));
            builder.clientAuth(this.clientAuth);
        });
    }
}

