/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.context;

import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

class ServletContextResourceFilePathResolver
implements ApplicationResourceLoader.FilePathResolver {
    private static final String RESOURCE_CLASS_NAME = "org.springframework.web.context.support.ServletContextResource";
    private final Class<?> resourceClass;

    ServletContextResourceFilePathResolver() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.resourceClass = ClassUtils.isPresent(RESOURCE_CLASS_NAME, classLoader) ? ClassUtils.resolveClassName(RESOURCE_CLASS_NAME, classLoader) : null;
    }

    @Override
    public String resolveFilePath(String location, Resource resource) {
        return this.resourceClass != null && this.resourceClass.isInstance(resource) ? location : null;
    }
}

