/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import io.netty.util.AttributeKey;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.context.SmartLifecycle;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;

public class ReactorClientHttpConnector
implements ClientHttpConnector,
SmartLifecycle {
    public static final AttributeKey<Map<String, Object>> ATTRIBUTES_KEY = AttributeKey.valueOf(ReactorClientHttpRequest.class.getName() + ".ATTRIBUTES");
    private static final Log logger = LogFactory.getLog(ReactorClientHttpConnector.class);
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true);
    @Nullable
    private final ReactorResourceFactory resourceFactory;
    @Nullable
    private final Function<HttpClient, HttpClient> mapper;
    @Nullable
    private volatile HttpClient httpClient;
    private boolean lazyStart = false;
    private final Object lifecycleMonitor = new Object();

    public ReactorClientHttpConnector() {
        this.httpClient = defaultInitializer.apply(HttpClient.create());
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorClientHttpConnector(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        this.httpClient = httpClient;
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorClientHttpConnector(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        this.resourceFactory = resourceFactory;
        this.mapper = mapper;
        if (resourceFactory.isRunning()) {
            this.httpClient = ReactorClientHttpConnector.createHttpClient(resourceFactory, mapper);
        } else {
            this.lazyStart = true;
        }
    }

    private static HttpClient createHttpClient(ReactorResourceFactory factory, Function<HttpClient, HttpClient> mapper) {
        return defaultInitializer.andThen(mapper).andThen(httpClient -> (HttpClient)httpClient.runOn(factory.getLoopResources())).apply(HttpClient.create((ConnectionProvider)factory.getConnectionProvider()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        HttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            Assert.state(this.resourceFactory != null && this.mapper != null, "Illegal configuration");
            if (this.resourceFactory.isRunning()) {
                Object object = this.lifecycleMonitor;
                synchronized (object) {
                    httpClient = this.httpClient;
                    if (httpClient == null && this.lazyStart) {
                        this.httpClient = httpClient = ReactorClientHttpConnector.createHttpClient(this.resourceFactory, this.mapper);
                        this.lazyStart = false;
                    }
                }
            }
            if (httpClient == null) {
                httpClient = ReactorClientHttpConnector.createHttpClient(this.resourceFactory, this.mapper);
            }
        }
        HttpClient.RequestSender requestSender = httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf(method.name()));
        requestSender = ReactorClientHttpConnector.setUri(requestSender, uri);
        AtomicReference responseRef = new AtomicReference();
        return requestSender.send((request, outbound) -> (Publisher)requestCallback.apply(this.adaptRequest(method, uri, (HttpClientRequest)request, (NettyOutbound)outbound))).responseConnection((response, connection) -> {
            responseRef.set(new ReactorClientHttpResponse((HttpClientResponse)response, (Connection)connection));
            return Mono.just((ClientHttpResponse)responseRef.get());
        }).next().doOnCancel(() -> {
            ReactorClientHttpResponse response = (ReactorClientHttpResponse)responseRef.get();
            if (response != null) {
                response.releaseAfterCancel(method);
            }
        });
    }

    private static HttpClient.RequestSender setUri(HttpClient.RequestSender requestSender, URI uri) {
        if (uri.isAbsolute()) {
            try {
                return (HttpClient.RequestSender)requestSender.uri(uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (HttpClient.RequestSender)requestSender.uri(uri.toString());
    }

    private ReactorClientHttpRequest adaptRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound nettyOutbound) {
        return new ReactorClientHttpRequest(method, uri, request, nettyOutbound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.resourceFactory != null && this.mapper != null) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (this.httpClient == null) {
                    this.httpClient = ReactorClientHttpConnector.createHttpClient(this.resourceFactory, this.mapper);
                    this.lazyStart = false;
                }
            }
        } else {
            logger.warn("Restarting a ReactorClientHttpConnector bean is only supported with externally managed Reactor Netty resources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.resourceFactory != null && this.mapper != null) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.httpClient = null;
                this.lazyStart = false;
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.httpClient != null;
    }

    @Override
    public int getPhase() {
        return 1;
    }
}

