/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.validation.FieldError;

public abstract class BindErrorUtils {
    private static final MessageSource defaultMessageSource = new MethodArgumentErrorMessageSource();

    public static String resolveAndJoin(List<? extends MessageSourceResolvable> errors) {
        return BindErrorUtils.resolveAndJoin(errors, defaultMessageSource, Locale.getDefault());
    }

    public static String resolveAndJoin(List<? extends MessageSourceResolvable> errors, MessageSource messageSource, Locale locale) {
        return BindErrorUtils.resolveAndJoin(", and ", "", "", errors, messageSource, locale);
    }

    public static String resolveAndJoin(CharSequence delimiter, CharSequence prefix, CharSequence suffix, List<? extends MessageSourceResolvable> errors, MessageSource messageSource, Locale locale) {
        return errors.stream().map(error2 -> messageSource.getMessage((MessageSourceResolvable)error2, locale)).filter(StringUtils::hasText).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static <E extends MessageSourceResolvable> Map<E, String> resolve(List<E> errors) {
        return BindErrorUtils.resolve(errors, defaultMessageSource, Locale.getDefault());
    }

    public static <E extends MessageSourceResolvable> Map<E, String> resolve(List<E> errors, MessageSource messageSource, Locale locale) {
        LinkedHashMap map = new LinkedHashMap(errors.size());
        errors.forEach(error2 -> map.put(error2, messageSource.getMessage((MessageSourceResolvable)error2, locale)));
        return map;
    }

    private static class MethodArgumentErrorMessageSource
    extends StaticMessageSource {
        MethodArgumentErrorMessageSource() {
            this.setUseCodeAsDefaultMessage(true);
        }

        @Override
        @Nullable
        protected String getDefaultMessage(MessageSourceResolvable resolvable, @Nullable Locale locale) {
            Object object;
            String message = super.getDefaultMessage(resolvable, locale);
            if (resolvable instanceof FieldError) {
                FieldError error2 = (FieldError)resolvable;
                object = error2.getField() + ": " + message;
            } else {
                object = message;
            }
            return object;
        }
    }
}

