/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.ModelMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.ModelPO;
import org.apache.ibatis.annotations.Param;

public class ModelMetaPostgreSQLProvider
extends ModelMetaBaseSQLProvider {
    @Override
    public String insertModelMetaOnDuplicateKeyUpdate(@Param(value="modelMeta") ModelPO modelPO) {
        return "INSERT INTO model_meta (model_id, model_name, metalake_id, catalog_id, schema_id, model_comment, model_properties, model_latest_version, audit_info, deleted_at) VALUES (#{modelMeta.modelId}, #{modelMeta.modelName}, #{modelMeta.metalakeId}, #{modelMeta.catalogId}, #{modelMeta.schemaId}, #{modelMeta.modelComment}, #{modelMeta.modelProperties}, #{modelMeta.modelLatestVersion}, #{modelMeta.auditInfo}, #{modelMeta.deletedAt}) ON CONFLICT (model_id) DO UPDATE SET model_name = #{modelMeta.modelName}, metalake_id = #{modelMeta.metalakeId}, catalog_id = #{modelMeta.catalogId}, schema_id = #{modelMeta.schemaId}, model_comment = #{modelMeta.modelComment}, model_properties = #{modelMeta.modelProperties}, model_latest_version = #{modelMeta.modelLatestVersion}, audit_info = #{modelMeta.auditInfo}, deleted_at = #{modelMeta.deletedAt}";
    }

    @Override
    public String softDeleteModelMetaBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return "UPDATE model_meta SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE schema_id = #{schemaId} AND model_name = #{modelName} AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelMetasByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE model_meta SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE catalog_id = #{catalogId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE model_meta SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteModelMetasBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE model_meta SET deleted_at = floor(extract(epoch from(current_timestamp - timestamp '1970-01-01 00:00:00'))*1000) WHERE schema_id = #{schemaId} AND deleted_at = 0";
    }

    @Override
    public String deleteModelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM model_meta WHERE model_id IN (SELECT model_id FROM model_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

