/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public final class HttpSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final HttpCommonAttributesGetter<REQUEST, ?> getter;
    private final Set<String> knownMethods;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        return HttpSpanNameExtractor.builder(getter).build();
    }

    public static <REQUEST> HttpSpanNameExtractorBuilder<REQUEST> builder(HttpCommonAttributesGetter<REQUEST, ?> getter) {
        return new HttpSpanNameExtractorBuilder<REQUEST>(getter);
    }

    HttpSpanNameExtractor(HttpSpanNameExtractorBuilder<REQUEST> builder) {
        this.getter = builder.httpAttributesGetter;
        this.knownMethods = new HashSet<String>(builder.knownMethods);
    }

    @Override
    public String extract(REQUEST request) {
        String method = this.getter.getHttpRequestMethod(request);
        String route = this.extractRoute(request);
        if (method != null) {
            if (!this.knownMethods.contains(method)) {
                method = "HTTP";
            }
            return route == null ? method : method + " " + route;
        }
        return "HTTP";
    }

    @Nullable
    private String extractRoute(REQUEST request) {
        if (this.getter instanceof HttpServerAttributesGetter) {
            return ((HttpServerAttributesGetter)this.getter).getHttpRoute(request);
        }
        return null;
    }
}

