/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.doris.operation;

import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.catalog.doris.utils.DorisUtils;
import org.apache.gravitino.catalog.jdbc.JdbcSchema;
import org.apache.gravitino.catalog.jdbc.operation.JdbcDatabaseOperations;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.meta.AuditInfo;

public class DorisDatabaseOperations
extends JdbcDatabaseOperations {
    public static final String COMMENT_KEY = "comment";

    public String generateCreateDatabaseSql(String databaseName, String comment, Map<String, String> properties) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(String.format("CREATE DATABASE `%s`", databaseName));
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        newProperties.put(COMMENT_KEY, comment);
        sqlBuilder.append(DorisUtils.generatePropertiesSql(newProperties));
        String result = sqlBuilder.toString();
        LOG.info("Generated create database:{} sql: {}", (Object)databaseName, (Object)result);
        return result;
    }

    public String generateDropDatabaseSql(String databaseName, boolean cascade) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(String.format("DROP DATABASE `%s`", databaseName));
        if (cascade) {
            sqlBuilder.append(" FORCE");
            return sqlBuilder.toString();
        }
        String query = String.format("SHOW TABLES IN `%s`", databaseName);
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            if (resultSet.next()) {
                throw new IllegalStateException(String.format("Database %s is not empty, the value of cascade should be true.", databaseName));
            }
        }
        catch (SQLException sqlException) {
            throw this.exceptionMapper.toGravitinoException(sqlException);
        }
        return sqlBuilder.toString();
    }

    public JdbcSchema load(String databaseName) throws NoSuchSchemaException {
        List allDatabases = this.listDatabases();
        String dbName = allDatabases.stream().filter(db -> db.equals(databaseName)).findFirst().orElseThrow(() -> new NoSuchSchemaException("Database %s could not be found", new Object[]{databaseName}));
        Map<String, String> properties = this.getDatabaseProperties(databaseName);
        String comment = properties.remove(COMMENT_KEY);
        return (JdbcSchema)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)((JdbcSchema.Builder)JdbcSchema.builder().withName(dbName)).withComment(comment)).withProperties(properties)).withAuditInfo(AuditInfo.EMPTY)).build();
    }

    protected Map<String, String> getDatabaseProperties(String databaseName) {
        String showCreateDatabaseSql = String.format("SHOW CREATE DATABASE `%s`", databaseName);
        StringBuilder createDatabaseSb = new StringBuilder();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(showCreateDatabaseSql);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                createDatabaseSb.append(resultSet.getString("Create Database"));
            }
        }
        catch (SQLException sqlException) {
            throw this.exceptionMapper.toGravitinoException(sqlException);
        }
        String createDatabaseSql = createDatabaseSb.toString();
        if (StringUtils.isEmpty((CharSequence)createDatabaseSql)) {
            throw new NoSuchTableException("Database %s does not exist.", new Object[]{databaseName});
        }
        return DorisUtils.extractPropertiesFromSql(createDatabaseSql);
    }

    protected boolean supportSchemaComment() {
        return true;
    }

    protected Set<String> createSysDatabaseNameSet() {
        return ImmutableSet.of((Object)"information_schema");
    }
}

