/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.UserRoleRelPO;
import org.apache.ibatis.annotations.Param;

public class UserRoleRelBaseSQLProvider {
    public String batchInsertUserRoleRel(@Param(value="userRoleRels") List<UserRoleRelPO> userRoleRels) {
        return "<script> INSERT INTO user_role_rel (user_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='userRoleRels' item='item' separator=','>(#{item.userId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach></script>";
    }

    public String batchInsertUserRoleRelOnDuplicateKeyUpdate(@Param(value="userRoleRels") List<UserRoleRelPO> userRoleRelPOs) {
        return "<script>INSERT INTO user_role_rel (user_id, role_id, audit_info, current_version, last_version, deleted_at) VALUES <foreach collection='userRoleRels' item='item' separator=','>(#{item.userId}, #{item.roleId}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})</foreach> ON DUPLICATE KEY UPDATE user_id = VALUES(user_id), role_id = VALUES(role_id), audit_info = VALUES(audit_info), current_version = VALUES(current_version), last_version = VALUES(last_version), deleted_at = VALUES(deleted_at)</script>";
    }

    public String softDeleteUserRoleRelByUserId(@Param(value="userId") Long userId) {
        return "UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id = #{userId} AND deleted_at = 0";
    }

    public String softDeleteUserRoleRelByUserAndRoles(@Param(value="userId") Long userId, @Param(value="roleIds") List<Long> roleIds) {
        return "<script>UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id = #{userId} AND role_id IN (<foreach collection='roleIds' item='roleId' separator=','>#{roleId}</foreach> ) AND deleted_at = 0</script>";
    }

    public String softDeleteUserRoleRelByMetalakeId(Long metalakeId) {
        return "UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id IN (SELECT user_id FROM user_meta WHERE metalake_id = #{metalakeId} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteUserRoleRelByRoleId(@Param(value="roleId") Long roleId) {
        return "UPDATE user_role_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE role_id = #{roleId} AND deleted_at = 0";
    }

    public String deleteUserRoleRelMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM user_role_rel WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

