/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.GroupMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.GroupPO;
import org.apache.ibatis.annotations.Param;

public class GroupMetaPostgreSQLProvider
extends GroupMetaBaseSQLProvider {
    @Override
    public String softDeleteGroupMetaByGroupId(Long groupId) {
        return "UPDATE group_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE group_id = #{groupId} AND deleted_at = 0";
    }

    @Override
    public String softDeleteGroupMetasByMetalakeId(Long metalakeId) {
        return "UPDATE group_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String insertGroupMetaOnDuplicateKeyUpdate(GroupPO groupPO) {
        return "INSERT INTO group_meta (group_id, group_name, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES ( #{groupMeta.groupId}, #{groupMeta.groupName}, #{groupMeta.metalakeId}, #{groupMeta.auditInfo}, #{groupMeta.currentVersion}, #{groupMeta.lastVersion}, #{groupMeta.deletedAt} ) ON CONFLICT(group_id) DO UPDATE SET group_name = #{groupMeta.groupName}, metalake_id = #{groupMeta.metalakeId}, audit_info = #{groupMeta.auditInfo}, current_version = #{groupMeta.currentVersion}, last_version = #{groupMeta.lastVersion}, deleted_at = #{groupMeta.deletedAt}";
    }

    @Override
    public String listExtendedGroupPOsByMetalakeId(Long metalakeId) {
        return "SELECT gt.group_id as groupId, gt.group_name as groupName, gt.metalake_id as metalakeId, gt.audit_info as auditInfo, gt.current_version as currentVersion, gt.last_version as lastVersion, gt.deleted_at as deletedAt, JSON_AGG(rot.role_name) as roleNames, JSON_AGG(rot.role_id) as roleIds FROM group_meta gt LEFT OUTER JOIN ( SELECT * FROM group_role_rel WHERE deleted_at = 0) AS rt ON rt.group_id = gt.group_id LEFT OUTER JOIN ( SELECT * FROM role_meta WHERE deleted_at = 0) AS rot ON rot.role_id = rt.role_id WHERE  gt.deleted_at = 0 AND gt.metalake_id = #{metalakeId} GROUP BY gt.group_id";
    }

    @Override
    public String deleteGroupMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM group_meta WHERE group_id IN (SELECT group_id FROM group_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit})";
    }
}

