/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.mysql;

import java.util.Set;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.connector.capability.CapabilityResult;

public class MysqlCatalogCapability
implements Capability {
    public static final String MYSQL_NAME_PATTERN = "^[\\w\\p{L}-$/=]{1,64}$";
    private static final Set<String> MYSQL_RESERVED_SCHEMAS = Set.of("mysql", "information_schema", "performance_schema", "sys");

    public CapabilityResult specificationOnName(Capability.Scope scope, String name) {
        if (!name.matches(MYSQL_NAME_PATTERN)) {
            return CapabilityResult.unsupported((String)String.format("The %s name '%s' is illegal.", scope, name));
        }
        if (scope == Capability.Scope.SCHEMA && MYSQL_RESERVED_SCHEMAS.contains(name.toLowerCase())) {
            return CapabilityResult.unsupported((String)String.format("The %s name '%s' is reserved and cannot be used.", scope, name));
        }
        return CapabilityResult.SUPPORTED;
    }
}

