/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.clone;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryWriter;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.clone.HiveCloneExtractor;
import org.apache.paimon.hive.clone.HiveCloneUtils;
import org.apache.paimon.hive.clone.HivePartitionFiles;
import org.apache.paimon.migrate.FileMetaUtils;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableCloneExtractor
implements HiveCloneExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableCloneExtractor.class);
    public static final HiveTableCloneExtractor INSTANCE = new HiveTableCloneExtractor();

    @Override
    public boolean matches(Table table) {
        return true;
    }

    @Override
    public List<FieldSchema> extractSchema(IMetaStoreClient client, Table hiveTable, String database, String table) throws Exception {
        return client.getSchema(database, table);
    }

    @Override
    public List<HivePartitionFiles> extractFiles(Map<String, String> catalogOptions, IMetaStoreClient client, Table table, FileIO fileIO, Identifier identifier, RowType partitionRowType, String defaultPartitionName, @Nullable PartitionPredicate predicate) throws Exception {
        return HiveTableCloneExtractor.listFromPureHiveTable(client, identifier, table, fileIO, partitionRowType, defaultPartitionName, predicate);
    }

    @Override
    public List<String> extractPartitionKeys(Table table) {
        return table.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> extractOptions(Table table) {
        Map hiveTableOptions = table.getParameters();
        HashMap<String, String> paimonOptions = new HashMap<String, String>();
        String comment = (String)hiveTableOptions.get("comment");
        if (comment != null) {
            paimonOptions.put("hive.comment", comment);
            paimonOptions.put("comment", comment);
        }
        String format = HiveCloneUtils.parseFormat(table);
        paimonOptions.put(CoreOptions.FILE_FORMAT.key(), format);
        Map<String, String> formatOptions = HiveTableCloneExtractor.getIdentifierPrefixOptions(format, hiveTableOptions);
        Map<String, String> sdFormatOptions = HiveTableCloneExtractor.getIdentifierPrefixOptions(format, table.getSd().getSerdeInfo().getParameters());
        formatOptions.putAll(sdFormatOptions);
        paimonOptions.putAll(formatOptions);
        String compression = HiveTableCloneExtractor.parseCompression(table, format, formatOptions);
        if (compression != null) {
            paimonOptions.put(CoreOptions.FILE_COMPRESSION.key(), compression);
        }
        return paimonOptions;
    }

    private static List<HivePartitionFiles> listFromPureHiveTable(IMetaStoreClient client, Identifier identifier, Table sourceTable, FileIO fileIO, RowType partitionRowType, String defaultPartitionName, @Nullable PartitionPredicate predicate) throws Exception {
        List partitions = client.listPartitions(identifier.getDatabaseName(), identifier.getTableName(), (short)Short.MAX_VALUE);
        String format = HiveCloneUtils.parseFormat(sourceTable);
        if (partitions.isEmpty()) {
            String location = sourceTable.getSd().getLocation();
            return Collections.singletonList(HiveTableCloneExtractor.listFiles(fileIO, location, BinaryRow.EMPTY_ROW, format));
        }
        ArrayList valueSetters = new ArrayList();
        partitionRowType.getFieldTypes().forEach(type -> valueSetters.add(BinaryWriter.createValueSetter((DataType)type)));
        ArrayList<HivePartitionFiles> results = new ArrayList<HivePartitionFiles>();
        for (Partition partition : partitions) {
            List partitionValues = partition.getValues();
            String location = partition.getSd().getLocation();
            BinaryRow partitionRow = FileMetaUtils.writePartitionValue((RowType)partitionRowType, (List)partitionValues, valueSetters, (String)defaultPartitionName);
            if (predicate != null && !predicate.test(partitionRow)) continue;
            results.add(HiveTableCloneExtractor.listFiles(fileIO, location, partitionRow, format));
        }
        return results;
    }

    private static HivePartitionFiles listFiles(FileIO fileIO, String location, BinaryRow partition, String format) throws IOException {
        List fileStatuses = Arrays.stream(fileIO.listStatus(new Path(location))).filter(s -> !s.isDir()).filter(HiveCloneUtils.HIDDEN_PATH_FILTER).collect(Collectors.toList());
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<Long> fileSizes = new ArrayList<Long>();
        for (FileStatus fileStatus : fileStatuses) {
            paths.add(fileStatus.getPath());
            fileSizes.add(fileStatus.getLen());
        }
        return new HivePartitionFiles(partition, paths, fileSizes, format);
    }

    private static String parseCompression(StorageDescriptor storageDescriptor) {
        Map serderParams = storageDescriptor.getSerdeInfo().getParameters();
        if (serderParams.containsKey("compression")) {
            return (String)serderParams.get("compression");
        }
        return null;
    }

    private static String parseCompression(Table table, String format, Map<String, String> formatOptions) {
        String compression = null;
        if (Objects.equals(format, "avro")) {
            compression = formatOptions.getOrDefault("avro.codec", HiveTableCloneExtractor.parseCompression(table.getSd()));
        } else if (Objects.equals(format, "parquet")) {
            compression = formatOptions.getOrDefault("parquet.compression", HiveTableCloneExtractor.parseCompression(table.getSd()));
        } else if (Objects.equals(format, "orc")) {
            compression = formatOptions.getOrDefault("orc.compress", HiveTableCloneExtractor.parseCompression(table.getSd()));
        }
        return compression;
    }

    public static Map<String, String> getIdentifierPrefixOptions(String formatIdentifier, Map<String, String> options) {
        HashMap<String, String> result = new HashMap<String, String>();
        String prefix = formatIdentifier.toLowerCase() + ".";
        for (String key : options.keySet()) {
            if (!key.toLowerCase().startsWith(prefix)) continue;
            result.put(prefix + key.substring(prefix.length()), options.get(key));
        }
        return result;
    }
}

