/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ApplicationStateData {
    public Map<ApplicationAttemptId, ApplicationAttemptStateData> attempts = new HashMap<ApplicationAttemptId, ApplicationAttemptStateData>();

    public static ApplicationStateData newInstance(long submitTime, long startTime, String user, ApplicationSubmissionContext submissionContext, RMAppState state, String diagnostics, long finishTime, CallerContext callerContext) {
        ApplicationStateData appState = (ApplicationStateData)Records.newRecord(ApplicationStateData.class);
        appState.setSubmitTime(submitTime);
        appState.setStartTime(startTime);
        appState.setUser(user);
        appState.setApplicationSubmissionContext(submissionContext);
        appState.setState(state);
        appState.setDiagnostics(diagnostics);
        appState.setFinishTime(finishTime);
        appState.setCallerContext(callerContext);
        return appState;
    }

    public static ApplicationStateData newInstance(long submitTime, long startTime, String user, ApplicationSubmissionContext submissionContext, RMAppState state, String diagnostics, long finishTime, CallerContext callerContext, Map<ApplicationTimeoutType, Long> applicationTimeouts) {
        ApplicationStateData appState = (ApplicationStateData)Records.newRecord(ApplicationStateData.class);
        appState.setSubmitTime(submitTime);
        appState.setStartTime(startTime);
        appState.setUser(user);
        appState.setApplicationSubmissionContext(submissionContext);
        appState.setState(state);
        appState.setDiagnostics(diagnostics);
        appState.setFinishTime(finishTime);
        appState.setCallerContext(callerContext);
        appState.setApplicationTimeouts(applicationTimeouts);
        return appState;
    }

    public static ApplicationStateData newInstance(long submitTime, long startTime, ApplicationSubmissionContext context, String user, CallerContext callerContext) {
        return ApplicationStateData.newInstance(submitTime, startTime, user, context, null, "", 0L, callerContext);
    }

    public static ApplicationStateData newInstance(long submitTime, long startTime, ApplicationSubmissionContext context, String user) {
        return ApplicationStateData.newInstance(submitTime, startTime, context, user, null);
    }

    public int getAttemptCount() {
        return this.attempts.size();
    }

    public ApplicationAttemptStateData getAttempt(ApplicationAttemptId attemptId) {
        return this.attempts.get(attemptId);
    }

    public int getFirstAttemptId() {
        int min = Integer.MAX_VALUE;
        for (ApplicationAttemptId attemptId : this.attempts.keySet()) {
            if (attemptId.getAttemptId() >= min) continue;
            min = attemptId.getAttemptId();
        }
        return min == Integer.MAX_VALUE ? 1 : min;
    }

    public abstract YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto getProto();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getSubmitTime();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setSubmitTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getStartTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setStartTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setUser(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getUser();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ApplicationSubmissionContext getApplicationSubmissionContext();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setApplicationSubmissionContext(ApplicationSubmissionContext var1);

    public abstract RMAppState getState();

    public abstract void setState(RMAppState var1);

    public abstract String getDiagnostics();

    public abstract void setDiagnostics(String var1);

    public abstract long getFinishTime();

    public abstract void setFinishTime(long var1);

    public abstract CallerContext getCallerContext();

    public abstract void setCallerContext(CallerContext var1);

    @InterfaceAudience.Public
    public abstract Map<ApplicationTimeoutType, Long> getApplicationTimeouts();

    @InterfaceAudience.Public
    public abstract void setApplicationTimeouts(Map<ApplicationTimeoutType, Long> var1);
}

