/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.metrics.MetricsCollector;
import co.cask.tephra.persist.AbstractTransactionLog;
import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionLogReader;
import co.cask.tephra.persist.TransactionLogWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class LocalFileTransactionLog
extends AbstractTransactionLog {
    private final File logFile;

    public LocalFileTransactionLog(File logFile, long timestamp, MetricsCollector metricsCollector) {
        super(timestamp, metricsCollector);
        this.logFile = logFile;
    }

    @Override
    public String getName() {
        return this.logFile.getAbsolutePath();
    }

    @Override
    protected TransactionLogWriter createWriter() throws IOException {
        return new LogWriter(this.logFile);
    }

    @Override
    public TransactionLogReader getReader() throws IOException {
        return new LogReader(this.logFile);
    }

    private static final class LogReader
    implements TransactionLogReader {
        private final FileInputStream fin;
        private final DataInputStream in;
        private AbstractTransactionLog.Entry reuseEntry = new AbstractTransactionLog.Entry();

        public LogReader(File logFile) throws IOException {
            this.fin = new FileInputStream(logFile);
            this.in = new DataInputStream(new BufferedInputStream(this.fin, 16384));
        }

        @Override
        public TransactionEdit next() throws IOException {
            AbstractTransactionLog.Entry entry = new AbstractTransactionLog.Entry();
            try {
                entry.readFields(this.in);
            }
            catch (EOFException eofe) {
                return null;
            }
            return entry.getEdit();
        }

        @Override
        public TransactionEdit next(TransactionEdit reuse) throws IOException {
            try {
                this.reuseEntry.getKey().readFields((DataInput)this.in);
                reuse.readFields(this.in);
            }
            catch (EOFException eofe) {
                return null;
            }
            return reuse;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
            this.fin.close();
        }
    }

    private static final class LogWriter
    implements TransactionLogWriter {
        private final FileOutputStream fos;
        private final DataOutputStream out;

        public LogWriter(File logFile) throws IOException {
            this.fos = new FileOutputStream(logFile);
            this.out = new DataOutputStream(new BufferedOutputStream(this.fos, 16384));
        }

        @Override
        public void append(AbstractTransactionLog.Entry entry) throws IOException {
            entry.write(this.out);
        }

        @Override
        public void sync() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.flush();
            this.out.close();
            this.fos.close();
        }
    }
}

