/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.dto.policy.PolicyContentDTO;
import org.apache.gravitino.dto.policy.PolicyDTO;
import org.apache.gravitino.dto.requests.PolicyCreateRequest;
import org.apache.gravitino.dto.requests.PolicySetRequest;
import org.apache.gravitino.dto.requests.PolicyUpdateRequest;
import org.apache.gravitino.dto.requests.PolicyUpdatesRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.MetadataObjectListResponse;
import org.apache.gravitino.dto.responses.NameListResponse;
import org.apache.gravitino.dto.responses.PolicyListResponse;
import org.apache.gravitino.dto.responses.PolicyResponse;
import org.apache.gravitino.dto.tag.MetadataObjectDTO;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyChange;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.policy.PolicyDispatcher;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.gravitino.server.web.rest.ExceptionHandlers;
import org.apache.gravitino.server.web.rest.OperationType;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="metalakes/{metalake}/policies")
public class PolicyOperations {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyOperations.class);
    private final PolicyDispatcher policyDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public PolicyOperations(PolicyDispatcher policyDispatcher) {
        this.policyDispatcher = policyDispatcher;
    }

    @GET
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-policies.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-policies", absolute=true)
    @AuthorizationExpression(expression="")
    public Response listPolicies(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @QueryParam(value="details") @DefaultValue(value="false") boolean verbose) {
        LOG.info("Received list policy {} request for metalake: {}", (Object)(verbose ? "infos" : "names"), (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (verbose) {
                    PolicyEntity[] policies = this.policyDispatcher.listPolicyInfos(metalake);
                    Object[] policyDTOs = (PolicyDTO[])Arrays.stream(policies).map(p -> PolicyOperations.toDTO(p, Optional.empty())).toArray(PolicyDTO[]::new);
                    policyDTOs = (PolicyDTO[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || POLICY::OWNER || ANY_APPLY_POLICY\n", (Entity.EntityType)Entity.EntityType.POLICY, (Object[])policyDTOs, policyDTO -> NameIdentifierUtil.ofPolicy((String)metalake, (String)policyDTO.name()));
                    LOG.info("List {} policies info under metalake: {}", (Object)policyDTOs.length, (Object)metalake);
                    return Utils.ok((Object)new PolicyListResponse((PolicyDTO[])policyDTOs));
                }
                Object[] policyNames = this.policyDispatcher.listPolicies(metalake);
                policyNames = policyNames == null ? new String[]{} : policyNames;
                policyNames = (String[])MetadataAuthzHelper.filterByExpression((String)metalake, (String)"METALAKE::OWNER || POLICY::OWNER || ANY_APPLY_POLICY\n", (Entity.EntityType)Entity.EntityType.POLICY, (Object[])policyNames, policyName -> NameIdentifierUtil.ofPolicy((String)metalake, (String)policyName));
                LOG.info("List {} policies under metalake: {}", (Object)policyNames.length, (Object)metalake);
                return Utils.ok((Object)new NameListResponse((String[])policyNames));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.LIST, "", metalake, e);
        }
    }

    @POST
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="create-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || METALAKE::CREATE_POLICY")
    public Response createPolicy(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, PolicyCreateRequest request) {
        LOG.info("Received create policy request under metalake: {}", (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                PolicyEntity policy = this.policyDispatcher.createPolicy(metalake, request.getName(), Policy.BuiltInType.fromPolicyType((String)request.getPolicyType()), request.getComment(), request.getEnabled().booleanValue(), DTOConverters.fromDTO((PolicyContentDTO)request.getPolicyContent()));
                LOG.info("Created policy: {} under metalake: {}", (Object)policy.name(), (Object)metalake);
                return Utils.ok((Object)new PolicyResponse(PolicyOperations.toDTO(policy, Optional.empty())));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.CREATE, request.getName(), metalake, e);
        }
    }

    @GET
    @Path(value="{policy}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="get-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="get-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || POLICY::OWNER || ANY_APPLY_POLICY\n")
    public Response getPolicy(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="policy") @AuthorizationMetadata(type=Entity.EntityType.POLICY) String name) {
        LOG.info("Received get policy request for policy: {} under metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                PolicyEntity policy = this.policyDispatcher.getPolicy(metalake, name);
                LOG.info("Get policy: {} under metalake: {}", (Object)name, (Object)metalake);
                return Utils.ok((Object)new PolicyResponse(PolicyOperations.toDTO(policy, Optional.empty())));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.GET, name, metalake, e);
        }
    }

    @PUT
    @Path(value="{policy}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="alter-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="alter-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || POLICY::OWNER")
    public Response alterPolicy(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="policy") @AuthorizationMetadata(type=Entity.EntityType.POLICY) String name, PolicyUpdatesRequest request) {
        LOG.info("Received alter policy request for policy: {} under metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                request.validate();
                PolicyChange[] changes = (PolicyChange[])request.getUpdates().stream().map(PolicyUpdateRequest::policyChange).toArray(PolicyChange[]::new);
                PolicyEntity policy = this.policyDispatcher.alterPolicy(metalake, name, changes);
                LOG.info("Altered policy: {} under metalake: {}", (Object)name, (Object)metalake);
                return Utils.ok((Object)new PolicyResponse(PolicyOperations.toDTO(policy, Optional.empty())));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.ALTER, name, metalake, e);
        }
    }

    @PATCH
    @Path(value="{policy}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="set-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="set-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || POLICY::OWNER")
    public Response setPolicy(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="policy") @AuthorizationMetadata(type=Entity.EntityType.POLICY) String name, PolicySetRequest request) {
        LOG.info("Received set policy request for policy: {} under metalake: {}", (Object)name, (Object)metalake);
        OperationType op = request.isEnable() ? OperationType.ENABLE : OperationType.DISABLE;
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                if (op == OperationType.ENABLE) {
                    this.policyDispatcher.enablePolicy(metalake, name);
                } else {
                    this.policyDispatcher.disablePolicy(metalake, name);
                }
                Response response = Utils.ok((Object)new BaseResponse());
                LOG.info("Successfully {} policy: {} under metalake: {}", new Object[]{request.isEnable() ? "enabled" : "disabled", name, metalake});
                return response;
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(op, name, metalake, e);
        }
    }

    @DELETE
    @Path(value="{policy}")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="delete-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="delete-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || POLICY::OWNER")
    public Response deletePolicy(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="policy") @AuthorizationMetadata(type=Entity.EntityType.POLICY) String name) {
        LOG.info("Received delete policy request for policy: {} under metalake: {}", (Object)name, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                boolean deleted = this.policyDispatcher.deletePolicy(metalake, name);
                if (!deleted) {
                    LOG.warn("Cannot find to be deleted policy {} under metalake {}", (Object)name, (Object)metalake);
                } else {
                    LOG.info("Deleted policy: {} under metalake: {}", (Object)name, (Object)metalake);
                }
                return Utils.ok((Object)new DropResponse(Boolean.valueOf(deleted)));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.DELETE, name, metalake, e);
        }
    }

    @GET
    @Path(value="{policy}/objects")
    @Produces(value={"application/vnd.gravitino.v1+json"})
    @Timed(name="list-objects-for-policy.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-objects-for-policy", absolute=true)
    @AuthorizationExpression(expression="METALAKE::OWNER || POLICY::OWNER || ANY_APPLY_POLICY\n")
    public Response listMetadataObjectsForPolicy(@PathParam(value="metalake") @AuthorizationMetadata(type=Entity.EntityType.METALAKE) String metalake, @PathParam(value="policy") @AuthorizationMetadata(type=Entity.EntityType.POLICY) String policyName) {
        LOG.info("Received list objects for policy: {} under metalake: {}", (Object)policyName, (Object)metalake);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                MetadataObject[] objects = this.policyDispatcher.listMetadataObjectsForPolicy(metalake, policyName);
                objects = objects == null ? new MetadataObject[]{} : objects;
                objects = MetadataAuthzHelper.filterMetadataObject((String)metalake, (MetadataObject[])objects);
                LOG.info("List {} objects for policy: {} under metalake: {}", new Object[]{objects.length, policyName, metalake});
                MetadataObjectDTO[] objectDTOs = (MetadataObjectDTO[])Arrays.stream(objects).map(DTOConverters::toDTO).toArray(MetadataObjectDTO[]::new);
                return Utils.ok((Object)new MetadataObjectListResponse(objectDTOs));
            });
        }
        catch (Exception e) {
            return ExceptionHandlers.handlePolicyException(OperationType.LIST, "", metalake, e);
        }
    }

    static PolicyDTO toDTO(PolicyEntity policy, Optional<Boolean> inherited) {
        PolicyDTO.Builder builder = PolicyDTO.builder().withName(policy.name()).withComment(policy.comment()).withPolicyType(policy.policyType().name().toLowerCase(Locale.ROOT)).withEnabled(policy.enabled()).withContent(DTOConverters.toDTO((PolicyContent)policy.content())).withInherited(inherited).withAudit(DTOConverters.toDTO((Audit)policy.auditInfo())).withInherited(inherited);
        return builder.build();
    }
}

