/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate.factory;

import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.mergetree.compact.aggregate.FieldNestedUpdateAgg;
import org.apache.paimon.mergetree.compact.aggregate.factory.FieldAggregatorFactory;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class FieldNestedUpdateAggFactory
implements FieldAggregatorFactory {
    public static final String NAME = "nested_update";

    @Override
    public FieldAggregator create(DataType fieldType, CoreOptions options, String field) {
        return this.createFieldNestedUpdateAgg(fieldType, options.fieldNestedUpdateAggNestedKey(field));
    }

    @Override
    public String identifier() {
        return NAME;
    }

    private FieldAggregator createFieldNestedUpdateAgg(DataType fieldType, List<String> nestedKey) {
        if (nestedKey == null) {
            nestedKey = Collections.emptyList();
        }
        String typeErrorMsg = "Data type for nested table column must be 'Array<Row>' but was '%s'.";
        Preconditions.checkArgument((boolean)(fieldType instanceof ArrayType), (String)typeErrorMsg, (Object[])new Object[]{fieldType});
        ArrayType arrayType = (ArrayType)fieldType;
        Preconditions.checkArgument((boolean)(arrayType.getElementType() instanceof RowType), (String)typeErrorMsg, (Object[])new Object[]{fieldType});
        return new FieldNestedUpdateAgg(this.identifier(), arrayType, nestedKey);
    }
}

