/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class ColumnCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String catalog;
    private final String schema;
    private final String table;
    private String column;

    public ColumnCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.catalog = this.name.getCatalogName();
        this.schema = this.name.getSchemaName();
        this.table = this.name.getTableName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        if (this.schema == null) {
            missingEntities.add("schema");
        }
        if (this.table == null) {
            missingEntities.add("table");
        }
        if ("list".equals(this.command)) {
            this.checkEntities(missingEntities);
            this.handleListCommand();
            return;
        }
        this.column = this.name.getColumnName();
        if (this.column == null) {
            missingEntities.add("column");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Entity doesn't support this action.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        if (this.line.hasOption("audit")) {
            this.gravitinoCommandLine.newColumnAudit(this.context, this.metalake, this.catalog, this.schema, this.table, this.column).validate().handle();
        } else {
            System.err.println("Entity doesn't support this action.");
            Main.exit(-1);
        }
    }

    private void handleCreateCommand() {
        String datatype = this.line.getOptionValue("datatype");
        String comment = this.line.getOptionValue("comment");
        String position = this.line.getOptionValue("position");
        boolean nullable = !this.line.hasOption("null") || this.line.getOptionValue("null").equals("true");
        boolean autoIncrement = this.line.hasOption("auto") && this.line.getOptionValue("auto").equals("true");
        String defaultValue = this.line.getOptionValue("default");
        this.gravitinoCommandLine.newAddColumn(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, datatype, comment, position, nullable, autoIncrement, defaultValue).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteColumn(this.context, this.metalake, this.catalog, this.schema, this.table, this.column).validate().handle();
    }

    private void handleUpdateCommand() {
        if (this.line.hasOption("comment")) {
            String comment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateColumnComment(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, comment).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateColumnName(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, newName).validate().handle();
        }
        if (this.line.hasOption("datatype") && !this.line.hasOption("default")) {
            String datatype = this.line.getOptionValue("datatype");
            this.gravitinoCommandLine.newUpdateColumnDatatype(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, datatype).validate().handle();
        }
        if (this.line.hasOption("position")) {
            String position = this.line.getOptionValue("position");
            this.gravitinoCommandLine.newUpdateColumnPosition(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, position).validate().handle();
        }
        if (this.line.hasOption("null")) {
            boolean nullable = this.line.getOptionValue("null").equals("true");
            this.gravitinoCommandLine.newUpdateColumnNullability(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, nullable).validate().handle();
        }
        if (this.line.hasOption("auto")) {
            boolean autoIncrement = this.line.getOptionValue("auto").equals("true");
            this.gravitinoCommandLine.newUpdateColumnAutoIncrement(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, autoIncrement).validate().handle();
        }
        if (this.line.hasOption("default")) {
            String defaultValue = this.line.getOptionValue("default");
            String dataType = this.line.getOptionValue("datatype");
            this.gravitinoCommandLine.newUpdateColumnDefault(this.context, this.metalake, this.catalog, this.schema, this.table, this.column, defaultValue, dataType).validate().handle();
        }
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListColumns(this.context, this.metalake, this.catalog, this.schema, this.table).validate().handle();
    }
}

