/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class TopicCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private final FullName name;
    private final String metalake;
    private final String catalog;
    private final String schema;
    private String topic;

    public TopicCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.name = new FullName(line);
        this.metalake = this.name.getMetalakeName();
        this.catalog = this.name.getCatalogName();
        this.schema = this.name.getSchemaName();
    }

    @Override
    protected void handle() {
        String userName = this.line.getOptionValue("login");
        Command.setAuthenticationMode(this.context.auth(), userName);
        ArrayList<String> missingEntities = Lists.newArrayList();
        if (this.catalog == null) {
            missingEntities.add("catalog");
        }
        if (this.schema == null) {
            missingEntities.add("schema");
        }
        if ("list".equals(this.command)) {
            this.checkEntities(missingEntities);
            this.handleListCommand();
            return;
        }
        this.topic = this.name.getTopicName();
        if (this.topic == null) {
            missingEntities.add("topic");
        }
        this.checkEntities(missingEntities);
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
        }
        return false;
    }

    private void handleDetailsCommand() {
        this.gravitinoCommandLine.newTopicDetails(this.context, this.metalake, this.catalog, this.schema, this.topic).validate().handle();
    }

    private void handleCreateCommand() {
        String comment = this.line.getOptionValue("comment");
        this.gravitinoCommandLine.newCreateTopic(this.context, this.metalake, this.catalog, this.schema, this.topic, comment).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteTopic(this.context, this.metalake, this.catalog, this.schema, this.topic).validate().handle();
    }

    private void handleUpdateCommand() {
        if (this.line.hasOption("comment")) {
            String comment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateTopicComment(this.context, this.metalake, this.catalog, this.schema, this.topic, comment).validate().handle();
        }
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        this.gravitinoCommandLine.newSetTopicProperty(this.context, this.metalake, this.catalog, this.schema, this.topic, property, value).validate().handle();
    }

    private void handleRemoveCommand() {
        String property = this.line.getOptionValue("property");
        this.gravitinoCommandLine.newRemoveTopicProperty(this.context, this.metalake, this.catalog, this.schema, this.topic, property).validate().handle();
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListTopicProperties(this.context, this.metalake, this.catalog, this.schema, this.topic).validate().handle();
    }

    private void handleListCommand() {
        this.gravitinoCommandLine.newListTopics(this.context, this.metalake, this.catalog, this.schema).validate().handle();
    }
}

