/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.MetalakeNotInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ManageCatalog
extends Command {
    private final String metalake;
    private final String catalog;
    private final CommandLine line;
    private final boolean enableMetalake;

    public ManageCatalog(CommandContext context, String metalake, String catalog) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.line = context.line();
        this.enableMetalake = this.line.hasOption("all");
    }

    @Override
    public void handle() {
        if (this.line.hasOption("enable")) {
            this.enableCatalog();
        } else if (this.line.hasOption("disable")) {
            this.disableCatalog();
        }
    }

    @Override
    public Command validate() {
        if (this.line.hasOption("enable") && this.line.hasOption("disable")) {
            this.exitWithError("Unable to use --enable and --disable at the same time.");
        }
        return super.validate();
    }

    private void enableCatalog() {
        try {
            if (this.enableMetalake) {
                GravitinoAdminClient adminClient = this.buildAdminClient();
                adminClient.enableMetalake(this.metalake);
            }
            GravitinoClient client = this.buildClient(this.metalake);
            client.enableCatalog(this.catalog);
        }
        catch (NoSuchMetalakeException noSuchMetalakeException) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException noSuchCatalogException) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (MetalakeNotInUseException notInUseException) {
            this.exitWithError(this.metalake + " not in use. please use --recursive option, or enable metalake first");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + "." + this.catalog + " has been enabled.");
    }

    private void disableCatalog() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.disableCatalog(this.catalog);
        }
        catch (NoSuchMetalakeException noSuchMetalakeException) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException noSuchCatalogException) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + "." + this.catalog + " has been disabled.");
    }
}

