/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.rel.types;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.gravitino.rel.types.Types;

public class Decimal {
    private final BigDecimal value;
    private final int precision;
    private final int scale;

    public static Decimal of(BigDecimal value, int precision, int scale) {
        return new Decimal(value, precision, scale);
    }

    public static Decimal of(BigDecimal value) {
        return new Decimal(value);
    }

    public static Decimal of(String value) {
        return Decimal.of(new BigDecimal(value));
    }

    public static Decimal of(String value, int precision, int scale) {
        return Decimal.of(new BigDecimal(value), precision, scale);
    }

    public BigDecimal value() {
        return this.value;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    private Decimal(BigDecimal value, int precision, int scale) {
        Types.DecimalType.checkPrecisionScale(precision, scale);
        Preconditions.checkArgument(precision >= value.precision(), "Precision of value cannot be greater than precision of decimal: %s > %s", value.precision(), precision);
        this.value = value.setScale(scale, RoundingMode.HALF_UP);
        this.scale = scale;
        this.precision = precision;
    }

    private Decimal(BigDecimal value) {
        this(value, Math.max(value.precision(), value.scale()), value.scale());
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Decimal)) {
            return false;
        }
        Decimal decimal = (Decimal)o;
        return this.scale == decimal.scale && this.precision == decimal.precision && Objects.equals(this.value, decimal.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.precision, this.scale);
    }
}

