/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerDispatcher;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.PolicyAlreadyExistsException;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyChange;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.policy.PolicyDispatcher;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class PolicyHookDispatcher
implements PolicyDispatcher {
    private final PolicyDispatcher dispatcher;

    public PolicyHookDispatcher(PolicyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public String[] listPolicies(String metalake) {
        return this.dispatcher.listPolicies(metalake);
    }

    @Override
    public PolicyEntity[] listPolicyInfos(String metalake) {
        return this.dispatcher.listPolicyInfos(metalake);
    }

    @Override
    public PolicyEntity getPolicy(String metalake, String policyName) throws NoSuchPolicyException {
        return this.dispatcher.getPolicy(metalake, policyName);
    }

    @Override
    public PolicyEntity createPolicy(String metalake, String name, Policy.BuiltInType type, String comment, boolean enabled, PolicyContent content) throws PolicyAlreadyExistsException {
        PolicyEntity policy = this.dispatcher.createPolicy(metalake, name, type, comment, enabled, content);
        OwnerDispatcher ownerDispatcher = GravitinoEnv.getInstance().ownerDispatcher();
        if (ownerDispatcher != null) {
            ownerDispatcher.setOwner(metalake, NameIdentifierUtil.toMetadataObject(NameIdentifierUtil.ofPolicy(metalake, name), Entity.EntityType.POLICY), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return policy;
    }

    @Override
    public PolicyEntity alterPolicy(String metalake, String policyName, PolicyChange ... changes) {
        return this.dispatcher.alterPolicy(metalake, policyName, changes);
    }

    @Override
    public void enablePolicy(String metalake, String policyName) throws NoSuchPolicyException {
        this.dispatcher.enablePolicy(metalake, policyName);
    }

    @Override
    public void disablePolicy(String metalake, String policyName) throws NoSuchPolicyException {
        this.dispatcher.disablePolicy(metalake, policyName);
    }

    @Override
    public boolean deletePolicy(String metalake, String policyName) {
        return this.dispatcher.deletePolicy(metalake, policyName);
    }

    @Override
    public MetadataObject[] listMetadataObjectsForPolicy(String metalake, String policyName) {
        return this.dispatcher.listMetadataObjectsForPolicy(metalake, policyName);
    }

    @Override
    public PolicyEntity[] listPolicyInfosForMetadataObject(String metalake, MetadataObject metadataObject) {
        return this.dispatcher.listPolicyInfosForMetadataObject(metalake, metadataObject);
    }

    @Override
    public String[] associatePoliciesForMetadataObject(String metalake, MetadataObject metadataObject, String[] policiesToAdd, String[] policiesToRemove) {
        return this.dispatcher.associatePoliciesForMetadataObject(metalake, metadataObject, policiesToAdd, policiesToRemove);
    }

    @Override
    public PolicyEntity getPolicyForMetadataObject(String metalake, MetadataObject metadataObject, String policyName) {
        return this.dispatcher.getPolicyForMetadataObject(metalake, metadataObject, policyName);
    }
}

