/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.JobMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.mapper.provider.postgresql.JobMetaPostgreSQLProvider;
import org.apache.gravitino.storage.relational.po.JobPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class JobMetaSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, JobMetaBaseSQLProvider> JOB_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new JobMetaMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new JobMetaH2Provider(), (Object)((Object)JDBCBackend.JDBCBackendType.POSTGRESQL), (Object)new JobMetaPostgreSQLProvider());

    public static JobMetaBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return JOB_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertJobMeta(@Param(value="jobMeta") JobPO jobPO) {
        return JobMetaSQLProviderFactory.getProvider().insertJobMeta(jobPO);
    }

    public static String insertJobMetaOnDuplicateKeyUpdate(@Param(value="jobMeta") JobPO jobPO) {
        return JobMetaSQLProviderFactory.getProvider().insertJobMetaOnDuplicateKeyUpdate(jobPO);
    }

    public static String listJobPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return JobMetaSQLProviderFactory.getProvider().listJobPOsByMetalake(metalakeName);
    }

    public static String listJobPOsByMetalakeAndTemplate(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return JobMetaSQLProviderFactory.getProvider().listJobPOsByMetalakeAndTemplate(metalakeName, jobTemplateName);
    }

    public static String selectJobPOByMetalakeAndRunId(@Param(value="metalakeName") String metalakeName, @Param(value="jobRunId") Long jobRunId) {
        return JobMetaSQLProviderFactory.getProvider().selectJobPOByMetalakeAndRunId(metalakeName, jobRunId);
    }

    public static String softDeleteJobMetaByMetalakeAndTemplate(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return JobMetaSQLProviderFactory.getProvider().softDeleteJobMetaByMetalakeAndTemplate(metalakeName, jobTemplateName);
    }

    public static String softDeleteJobMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return JobMetaSQLProviderFactory.getProvider().softDeleteJobMetasByMetalakeId(metalakeId);
    }

    public static String deleteJobMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return JobMetaSQLProviderFactory.getProvider().deleteJobMetasByLegacyTimeline(legacyTimeline, limit);
    }

    public static String softDeleteJobMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline) {
        return JobMetaSQLProviderFactory.getProvider().softDeleteJobMetasByLegacyTimeline(legacyTimeline);
    }

    public static String softDeleteJobMetaByRunId(@Param(value="jobRunId") Long jobRunId) {
        return JobMetaSQLProviderFactory.getProvider().softDeleteJobMetaByRunId(jobRunId);
    }

    static class JobMetaMySQLProvider
    extends JobMetaBaseSQLProvider {
        JobMetaMySQLProvider() {
        }
    }

    static class JobMetaH2Provider
    extends JobMetaBaseSQLProvider {
        JobMetaH2Provider() {
        }
    }
}

