/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import org.apache.iceberg.aws.s3.AnalyticsAcceleratorInputStreamWrapper;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.aws.s3.S3InputFile;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.s3.analyticsaccelerator.ObjectClientConfiguration;
import software.amazon.s3.analyticsaccelerator.S3SdkObjectClient;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStream;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStreamConfiguration;
import software.amazon.s3.analyticsaccelerator.S3SeekableInputStreamFactory;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

class AnalyticsAcceleratorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsAcceleratorUtil.class);
    private static final Cache<Pair<S3AsyncClient, S3FileIOProperties>, S3SeekableInputStreamFactory> STREAM_FACTORY_CACHE = Caffeine.newBuilder().maximumSize(100L).removalListener((key, factory, cause) -> AnalyticsAcceleratorUtil.close(factory)).build();

    private AnalyticsAcceleratorUtil() {
    }

    public static SeekableInputStream newStream(S3InputFile inputFile) {
        S3URI uri = S3URI.of((String)inputFile.uri().bucket(), (String)inputFile.uri().key());
        HeadObjectResponse metadata = inputFile.getObjectMetadata();
        OpenStreamInformation openStreamInfo = OpenStreamInformation.builder().objectMetadata(ObjectMetadata.builder().contentLength(metadata.contentLength().longValue()).etag(metadata.eTag()).build()).build();
        S3SeekableInputStreamFactory factory = (S3SeekableInputStreamFactory)STREAM_FACTORY_CACHE.get((Object)Pair.of((Object)inputFile.asyncClient(), (Object)inputFile.s3FileIOProperties()), AnalyticsAcceleratorUtil::createNewFactory);
        try {
            S3SeekableInputStream seekableInputStream = factory.createStream(uri, openStreamInfo);
            return new AnalyticsAcceleratorInputStreamWrapper(seekableInputStream);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create S3 analytics accelerator input stream for: %s", new Object[]{inputFile.uri()});
        }
    }

    private static S3SeekableInputStreamFactory createNewFactory(Pair<S3AsyncClient, S3FileIOProperties> cacheKey) {
        ConnectorConfiguration connectorConfiguration = new ConnectorConfiguration(((S3FileIOProperties)cacheKey.second()).s3AnalyticsacceleratorProperties());
        S3SeekableInputStreamConfiguration streamConfiguration = S3SeekableInputStreamConfiguration.fromConfiguration((ConnectorConfiguration)connectorConfiguration);
        ObjectClientConfiguration objectClientConfiguration = ObjectClientConfiguration.fromConfiguration((ConnectorConfiguration)connectorConfiguration);
        S3SdkObjectClient objectClient = new S3SdkObjectClient((S3AsyncClient)cacheKey.first(), objectClientConfiguration);
        return new S3SeekableInputStreamFactory((ObjectClient)objectClient, streamConfiguration);
    }

    private static void close(S3SeekableInputStreamFactory factory) {
        if (factory != null) {
            try {
                factory.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close S3SeekableInputStreamFactory", (Throwable)e);
            }
        }
    }

    public static void cleanupCache(S3AsyncClient asyncClient, S3FileIOProperties s3FileIOProperties) {
        STREAM_FACTORY_CACHE.invalidate((Object)Pair.of((Object)asyncClient, (Object)s3FileIOProperties));
    }
}

