/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.test.ClientBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SaslAuthTest
extends ClientBase {
    private AtomicInteger authFailed = new AtomicInteger(0);

    @BeforeClass
    public static void init() {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        try {
            File tmpDir = SaslAuthTest.createTmpDir();
            File saslConfFile = new File(tmpDir, "jaas.conf");
            String jaasContent = SaslAuthTest.getJaasFileContent();
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write(jaasContent);
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getJaasFileContent() {
        StringBuilder jaasContent = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        jaasContent.append("Server {");
        jaasContent.append(newLine);
        jaasContent.append("org.apache.zookeeper.server.auth.DigestLoginModule required");
        jaasContent.append(newLine);
        jaasContent.append("user_super=\"test\";");
        jaasContent.append(newLine);
        jaasContent.append("};");
        jaasContent.append(newLine);
        jaasContent.append("Client {");
        jaasContent.append(newLine);
        jaasContent.append("org.apache.zookeeper.server.auth.DigestLoginModule required");
        jaasContent.append(newLine);
        jaasContent.append("username=\"super\"");
        jaasContent.append(newLine);
        jaasContent.append("password=\"test\";");
        jaasContent.append(newLine);
        jaasContent.append("};");
        jaasContent.append(newLine);
        return jaasContent.toString();
    }

    @AfterClass
    public static void clean() {
        System.clearProperty("zookeeper.authProvider.1");
        System.clearProperty("java.security.auth.login.config");
    }

    @Override
    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        MyWatcher watcher = new MyWatcher();
        return this.createClient(watcher, hp);
    }

    @Test
    public void testAuth() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Thread.sleep(1000L);
        }
        finally {
            zk.close();
        }
    }

    @Test
    public void testValidSaslIds() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ArrayList<String> validIds = new ArrayList<String>();
        validIds.add("user");
        validIds.add("service/host.name.com");
        validIds.add("user@KERB.REALM");
        validIds.add("service/host.name.com@KERB.REALM");
        int i = 0;
        for (String validId : validIds) {
            ArrayList<ACL> aclList = new ArrayList<ACL>();
            ACL acl = new ACL(0, new Id("sasl", validId));
            aclList.add(acl);
            zk.create("/valid" + i, null, aclList, CreateMode.PERSISTENT);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidSaslIds() throws Exception {
        TestableZooKeeper zk = this.createClient();
        ArrayList<String> invalidIds = new ArrayList<String>();
        invalidIds.add("user@KERB.REALM/server.com");
        invalidIds.add("user@KERB.REALM1@KERB.REALM2");
        int i = 0;
        for (String invalidId : invalidIds) {
            ArrayList<ACL> aclList = new ArrayList<ACL>();
            try {
                ACL acl = new ACL(0, new Id("sasl", invalidId));
                aclList.add(acl);
                zk.create("/invalid" + i, null, aclList, CreateMode.PERSISTENT);
                Assert.fail((String)"SASLAuthenticationProvider.isValid() failed to catch invalid Id.");
            }
            catch (KeeperException.InvalidACLException invalidACLException) {}
            continue;
            finally {
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZKOperationsAfterClientSaslAuthFailure() throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(this.hostPort, CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        try {
            this.setSaslFailureFlag(zk);
            int totalTry = 10;
            int tryCount = 0;
            boolean success = false;
            while (!success && tryCount++ <= totalTry) {
                try {
                    zk.create("/saslAuthFail", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                    success = true;
                }
                catch (KeeperException.ConnectionLossException e) {
                    Thread.sleep(1000L);
                }
            }
            Assert.assertTrue((String)"ZNode creation is failing continuously after Sasl auth failure.", (boolean)success);
        }
        finally {
            zk.close();
        }
    }

    private void setSaslFailureFlag(ZooKeeper zk) throws Exception {
        Field cnxnField = zk.getClass().getDeclaredField("cnxn");
        cnxnField.setAccessible(true);
        ClientCnxn clientCnxn = (ClientCnxn)cnxnField.get(zk);
        Field sendThreadField = clientCnxn.getClass().getDeclaredField("sendThread");
        sendThreadField.setAccessible(true);
        ClientCnxn.SendThread sendThread = (ClientCnxn.SendThread)sendThreadField.get(clientCnxn);
        Field saslLoginFailedField = sendThread.getClass().getDeclaredField("saslLoginFailed");
        saslLoginFailedField.setAccessible(true);
        saslLoginFailedField.setBoolean(sendThread, true);
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        private MyWatcher() {
        }

        @Override
        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslAuthTest.this.authFailed.incrementAndGet();
            } else {
                super.process(event);
            }
        }
    }
}

