/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.starrocks.converter;

import com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import org.apache.gravitino.catalog.jdbc.converter.JdbcExceptionConverter;
import org.apache.gravitino.exceptions.ConnectionFailedException;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;
import org.apache.gravitino.exceptions.IllegalPropertyException;
import org.apache.gravitino.exceptions.NoSuchColumnException;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.exceptions.UnauthorizedException;

public class StarRocksExceptionConverter
extends JdbcExceptionConverter {
    @VisibleForTesting
    static final int CODE_DATABASE_EXISTS = 1007;
    static final int CODE_TABLE_EXISTS = 1050;
    static final int CODE_DATABASE_NOT_EXISTS = 1008;
    static final int CODE_UNKNOWN_DATABASE = 1049;
    static final int CODE_UNKNOWN_DATABASE_2 = 5501;
    static final int CODE_NO_SUCH_TABLE = 1051;
    static final int CODE_NO_SUCH_TABLE_2 = 5502;
    static final int CODE_UNAUTHORIZED = 1045;
    static final int CODE_NO_SUCH_COLUMN = 1054;
    static final int CODE_DELETE_NON_EXISTING_PARTITION = 1507;
    static final int CODE_PARTITION_ALREADY_EXISTS = 1517;
    static final int CODE_GENERIC_ERROR = 5064;

    public GravitinoRuntimeException toGravitinoException(SQLException se) {
        int errorCode = se.getErrorCode();
        switch (errorCode) {
            case 1007: {
                return new SchemaAlreadyExistsException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1050: {
                return new TableAlreadyExistsException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1008: 
            case 1049: 
            case 5501: {
                return new NoSuchSchemaException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1051: 
            case 5502: {
                return new NoSuchTableException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1045: {
                return new UnauthorizedException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1054: {
                return new NoSuchColumnException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1507: {
                return new NoSuchPartitionException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 1517: {
                return new PartitionAlreadyExistsException((Throwable)se, se.getMessage(), new Object[0]);
            }
            case 5064: {
                if (se.getMessage() != null && se.getMessage().contains("Unknown properties")) {
                    return new IllegalPropertyException((Throwable)se, se.getMessage(), new Object[0]);
                }
                return new GravitinoRuntimeException((Throwable)se, se.getMessage());
            }
        }
        if (se.getMessage() != null && se.getMessage().contains("Access denied")) {
            return new ConnectionFailedException((Throwable)se, se.getMessage(), new Object[0]);
        }
        return new GravitinoRuntimeException((Throwable)se, se.getMessage());
    }
}

