/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.client.apache.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.lancedb.lance.namespace.client.apache.ApiClient;
import com.lancedb.lance.namespace.client.apache.ApiException;
import com.lancedb.lance.namespace.client.apache.BaseApi;
import com.lancedb.lance.namespace.client.apache.Configuration;
import com.lancedb.lance.namespace.client.apache.Pair;
import com.lancedb.lance.namespace.model.CreateTableTagRequest;
import com.lancedb.lance.namespace.model.DeleteTableTagRequest;
import com.lancedb.lance.namespace.model.GetTableTagVersionRequest;
import com.lancedb.lance.namespace.model.GetTableTagVersionResponse;
import com.lancedb.lance.namespace.model.ListTableTagsResponse;
import com.lancedb.lance.namespace.model.UpdateTableTagRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class TagApi
extends BaseApi {
    public TagApi() {
        super(Configuration.getDefaultApiClient());
    }

    public TagApi(ApiClient apiClient) {
        super(apiClient);
    }

    public void createTableTag(String id, CreateTableTagRequest createTableTagRequest, String delimiter) throws ApiException {
        this.createTableTag(id, createTableTagRequest, delimiter, Collections.emptyMap());
    }

    public void createTableTag(String id, CreateTableTagRequest createTableTagRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        CreateTableTagRequest localVarPostBody = createTableTagRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling createTableTag");
        }
        if (createTableTagRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createTableTagRequest' when calling createTableTag");
        }
        String localVarPath = "/v1/table/{id}/tags/create".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteTableTag(String id, DeleteTableTagRequest deleteTableTagRequest, String delimiter) throws ApiException {
        this.deleteTableTag(id, deleteTableTagRequest, delimiter, Collections.emptyMap());
    }

    public void deleteTableTag(String id, DeleteTableTagRequest deleteTableTagRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DeleteTableTagRequest localVarPostBody = deleteTableTagRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteTableTag");
        }
        if (deleteTableTagRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteTableTagRequest' when calling deleteTableTag");
        }
        String localVarPath = "/v1/table/{id}/tags/delete".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GetTableTagVersionResponse getTableTagVersion(String id, GetTableTagVersionRequest getTableTagVersionRequest, String delimiter) throws ApiException {
        return this.getTableTagVersion(id, getTableTagVersionRequest, delimiter, Collections.emptyMap());
    }

    public GetTableTagVersionResponse getTableTagVersion(String id, GetTableTagVersionRequest getTableTagVersionRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        GetTableTagVersionRequest localVarPostBody = getTableTagVersionRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getTableTagVersion");
        }
        if (getTableTagVersionRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'getTableTagVersionRequest' when calling getTableTagVersion");
        }
        String localVarPath = "/v1/table/{id}/tags/version".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<GetTableTagVersionResponse> localVarReturnType = new TypeReference<GetTableTagVersionResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListTableTagsResponse listTableTags(String id, String delimiter, String pageToken, Integer limit) throws ApiException {
        return this.listTableTags(id, delimiter, pageToken, limit, Collections.emptyMap());
    }

    public ListTableTagsResponse listTableTags(String id, String delimiter, String pageToken, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listTableTags");
        }
        String localVarPath = "/v1/table/{id}/tags/list".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("page_token", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ListTableTagsResponse> localVarReturnType = new TypeReference<ListTableTagsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void updateTableTag(String id, UpdateTableTagRequest updateTableTagRequest, String delimiter) throws ApiException {
        this.updateTableTag(id, updateTableTagRequest, delimiter, Collections.emptyMap());
    }

    public void updateTableTag(String id, UpdateTableTagRequest updateTableTagRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        UpdateTableTagRequest localVarPostBody = updateTableTagRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateTableTag");
        }
        if (updateTableTagRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateTableTagRequest' when calling updateTableTag");
        }
        String localVarPath = "/v1/table/{id}/tags/update".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

