/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization;

import java.io.Closeable;
import java.io.IOException;
import org.apache.gravitino.Configs;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.authorization.GravitinoAuthorizer;
import org.apache.gravitino.server.ServerConfig;
import org.apache.gravitino.server.authorization.PassThroughAuthorizer;

public class GravitinoAuthorizerProvider
implements Closeable {
    private static final GravitinoAuthorizerProvider INSTANCE = new GravitinoAuthorizerProvider();
    private volatile GravitinoAuthorizer gravitinoAuthorizer;

    private GravitinoAuthorizerProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ServerConfig serverConfig) {
        if (this.gravitinoAuthorizer == null) {
            GravitinoAuthorizerProvider gravitinoAuthorizerProvider = this;
            synchronized (gravitinoAuthorizerProvider) {
                if (this.gravitinoAuthorizer == null) {
                    boolean enableAuthorization = (Boolean)serverConfig.get(Configs.ENABLE_AUTHORIZATION);
                    if (enableAuthorization) {
                        String authorizationImpl = (String)serverConfig.get(Configs.AUTHORIZATION_IMPL);
                        try {
                            this.gravitinoAuthorizer = (GravitinoAuthorizer)Class.forName(authorizationImpl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Can not initialize GravitinoAuthorizer", e);
                        }
                    } else {
                        this.gravitinoAuthorizer = new PassThroughAuthorizer();
                    }
                    this.gravitinoAuthorizer.initialize();
                    GravitinoEnv.getInstance().setGravitinoAuthorizer(this.gravitinoAuthorizer);
                }
            }
        }
    }

    public static GravitinoAuthorizerProvider getInstance() {
        return INSTANCE;
    }

    public GravitinoAuthorizer getGravitinoAuthorizer() {
        return this.gravitinoAuthorizer;
    }

    @Override
    public void close() throws IOException {
        GravitinoEnv.getInstance().setGravitinoAuthorizer(null);
        if (this.gravitinoAuthorizer != null) {
            this.gravitinoAuthorizer.close();
        }
        this.gravitinoAuthorizer = null;
    }
}

