/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergViewEvent;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.LoadViewResponse;

@DeveloperApi
public class IcebergReplaceViewEvent
extends IcebergViewEvent {
    private final UpdateTableRequest replaceViewRequest;
    private final LoadViewResponse loadViewResponse;

    public IcebergReplaceViewEvent(IcebergRequestContext icebergRequestContext, NameIdentifier viewIdentifier, UpdateTableRequest replaceViewRequest, LoadViewResponse loadViewResponse) {
        super(icebergRequestContext, viewIdentifier);
        this.replaceViewRequest = IcebergRESTUtils.cloneIcebergRESTObject(replaceViewRequest, UpdateTableRequest.class);
        this.loadViewResponse = IcebergRESTUtils.cloneIcebergRESTObject(loadViewResponse, LoadViewResponse.class);
    }

    public UpdateTableRequest renameViewRequest() {
        return this.replaceViewRequest;
    }

    public LoadViewResponse loadViewResponse() {
        return this.loadViewResponse;
    }

    public OperationType operationType() {
        return OperationType.ALTER_VIEW;
    }
}

