/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.StorageUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestStorageUnit {
    static final double KB = 1024.0;
    static final double MB = 1048576.0;
    static final double GB = 1.073741824E9;
    static final double TB = 1.099511627776E12;
    static final double PB = 1.125899906842624E15;
    static final double EB = 1.152921504606847E18;

    @Test
    public void testByteToKiloBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1024.0, 1.0);
        results.put(2048.0, 2.0);
        results.put(-1024.0, -1.0);
        results.put(34565.0, 33.7549);
        results.put(2.23344332E8, 218109.6992);
        results.put(1234983.0, 1206.0381);
        results.put(1234332.0, 1205.4023);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            MatcherAssert.assertThat((Object)StorageUnit.BYTES.toKBs(((Double)entry.getKey()).doubleValue()), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testBytesToMegaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1048576.0, 1.0);
        results.put(2.4117248E7, 23.0);
        results.put(4.59920023E8, 438.6139);
        results.put(2.34443233E8, 223.5825);
        results.put(-3.5651584E7, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            MatcherAssert.assertThat((Object)StorageUnit.BYTES.toMBs(((Double)entry.getKey()).doubleValue()), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testBytesToGigaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.073741824E9, 1.0);
        results.put(2.4696061952E10, 23.0);
        results.put(4.59920023E8, 0.4283);
        results.put(2.34443233E8, 0.2183);
        results.put(-3.6507222016E10, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            MatcherAssert.assertThat((Object)StorageUnit.BYTES.toGBs(((Double)entry.getKey()).doubleValue()), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testBytesToTerraBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.09951E12, 1.0);
        results.put(2.52888E13, 23.0);
        results.put(4.59920023E8, 4.0E-4);
        results.put(2.34443233E8, 2.0E-4);
        results.put(-3.73834E13, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            MatcherAssert.assertThat((Object)StorageUnit.BYTES.toTBs(((Double)entry.getKey()).doubleValue()), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testBytesToPetaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.1259E15, 1.0);
        results.put(2.58957E16, 23.0);
        results.put(4.70958E11, 4.0E-4);
        results.put(2.34443233E8, 0.0);
        results.put(-3.82806E16, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            MatcherAssert.assertThat((Object)StorageUnit.BYTES.toPBs(((Double)entry.getKey()).doubleValue()), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testBytesToExaBytes() {
        HashMap<Double, Double> results = new HashMap<Double, Double>();
        results.put(1.15292E18, 1.0);
        results.put(2.65172E19, 23.0);
        results.put(4.82261E14, 4.0E-4);
        results.put(2.34443233E8, 0.0);
        results.put(-3.91993E19, -34.0);
        results.put(0.0, 0.0);
        for (Map.Entry entry : results.entrySet()) {
            MatcherAssert.assertThat((Object)StorageUnit.BYTES.toEBs(((Double)entry.getKey()).doubleValue()), (Matcher)CoreMatchers.is(entry.getValue()));
        }
    }

    @Test
    public void testByteConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.getShortName(), (Matcher)CoreMatchers.is((Object)"b"));
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"b"));
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.getLongName(), (Matcher)CoreMatchers.is((Object)"bytes"));
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.toString(), (Matcher)CoreMatchers.is((Object)"bytes"));
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.toBytes(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.BYTES.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.BYTES.fromBytes(10.0), (Matcher)CoreMatchers.is((Object)10.0));
    }

    @Test
    public void testKBConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.KB.getShortName(), (Matcher)CoreMatchers.is((Object)"kb"));
        MatcherAssert.assertThat((Object)StorageUnit.KB.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"k"));
        MatcherAssert.assertThat((Object)StorageUnit.KB.getLongName(), (Matcher)CoreMatchers.is((Object)"kilobytes"));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toString(), (Matcher)CoreMatchers.is((Object)"kilobytes"));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toKBs(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.KB.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1024.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.fromBytes(1024.0), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toKBs(10.0), (Matcher)CoreMatchers.is((Object)10.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toMBs(3072.0), (Matcher)CoreMatchers.is((Object)3.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toGBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1024.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toTBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toPBs(1.0995116E12), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.KB.toEBs(1.1258999E15), (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testMBConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.MB.getShortName(), (Matcher)CoreMatchers.is((Object)"mb"));
        MatcherAssert.assertThat((Object)StorageUnit.MB.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"m"));
        MatcherAssert.assertThat((Object)StorageUnit.MB.getLongName(), (Matcher)CoreMatchers.is((Object)"megabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toString(), (Matcher)CoreMatchers.is((Object)"megabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toMBs(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.MB.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1048576.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.fromBytes(1048576.0), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toKBs(1.0), (Matcher)CoreMatchers.is((Object)1024.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toMBs(10.0), (Matcher)CoreMatchers.is((Object)10.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toGBs(4.4040192E7), (Matcher)CoreMatchers.is((Object)43008.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toTBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1024.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toPBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.MB.toEBs(1.099511627776E12), (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testGBConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.GB.getShortName(), (Matcher)CoreMatchers.is((Object)"gb"));
        MatcherAssert.assertThat((Object)StorageUnit.GB.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"g"));
        MatcherAssert.assertThat((Object)StorageUnit.GB.getLongName(), (Matcher)CoreMatchers.is((Object)"gigabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toString(), (Matcher)CoreMatchers.is((Object)"gigabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toGBs(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.GB.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1.073741824E9));
        MatcherAssert.assertThat((Object)StorageUnit.GB.fromBytes(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toKBs(1.0), (Matcher)CoreMatchers.is((Object)1048576.0));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toMBs(10.0), (Matcher)CoreMatchers.is((Object)10240.0));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toGBs(4.4040192E7), (Matcher)CoreMatchers.is((Object)4.4040192E7));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toTBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1048576.0));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toPBs(1.07375E9), (Matcher)CoreMatchers.is((Object)1024.0078));
        MatcherAssert.assertThat((Object)StorageUnit.GB.toEBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testTBConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.TB.getShortName(), (Matcher)CoreMatchers.is((Object)"tb"));
        MatcherAssert.assertThat((Object)StorageUnit.TB.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"t"));
        MatcherAssert.assertThat((Object)StorageUnit.TB.getLongName(), (Matcher)CoreMatchers.is((Object)"terabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toString(), (Matcher)CoreMatchers.is((Object)"terabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toTBs(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.TB.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1.099511627776E12));
        MatcherAssert.assertThat((Object)StorageUnit.TB.fromBytes(1.099511627776E12), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toKBs(1.0), (Matcher)CoreMatchers.is((Object)1.073741824E9));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toMBs(10.0), (Matcher)CoreMatchers.is((Object)1.048576E7));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toGBs(4.4040192E7), (Matcher)CoreMatchers.is((Object)4.5097156608E10));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toTBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.073741824E9));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toPBs(1024.0), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.TB.toEBs(1048576.0), (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testPBConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.PB.getShortName(), (Matcher)CoreMatchers.is((Object)"pb"));
        MatcherAssert.assertThat((Object)StorageUnit.PB.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"p"));
        MatcherAssert.assertThat((Object)StorageUnit.PB.getLongName(), (Matcher)CoreMatchers.is((Object)"petabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toString(), (Matcher)CoreMatchers.is((Object)"petabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toPBs(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.PB.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1.125899906842624E15));
        MatcherAssert.assertThat((Object)StorageUnit.PB.fromBytes(1.125899906842624E15), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toKBs(1.0), (Matcher)CoreMatchers.is((Object)1.099511627776E12));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toMBs(10.0), (Matcher)CoreMatchers.is((Object)1.073741824E10));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toGBs(4.4040192E7), (Matcher)CoreMatchers.is((Object)4.6179488366592E13));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toTBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.099511627776E12));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toPBs(1024.0), (Matcher)CoreMatchers.is((Object)1024.0));
        MatcherAssert.assertThat((Object)StorageUnit.PB.toEBs(1024.0), (Matcher)CoreMatchers.is((Object)1.0));
    }

    @Test
    public void testEBConversions() {
        MatcherAssert.assertThat((Object)StorageUnit.EB.getShortName(), (Matcher)CoreMatchers.is((Object)"eb"));
        MatcherAssert.assertThat((Object)StorageUnit.EB.getSuffixChar(), (Matcher)CoreMatchers.is((Object)"e"));
        MatcherAssert.assertThat((Object)StorageUnit.EB.getLongName(), (Matcher)CoreMatchers.is((Object)"exabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toString(), (Matcher)CoreMatchers.is((Object)"exabytes"));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toEBs(1024.0), (Matcher)CoreMatchers.is((Object)StorageUnit.EB.getDefault(1024.0)));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toBytes(1.0), (Matcher)CoreMatchers.is((Object)1.152921504606847E18));
        MatcherAssert.assertThat((Object)StorageUnit.EB.fromBytes(1.152921504606847E18), (Matcher)CoreMatchers.is((Object)1.0));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toKBs(1.0), (Matcher)CoreMatchers.is((Object)1.125899906842624E15));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toMBs(10.0), (Matcher)CoreMatchers.is((Object)1.099511627776E13));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toGBs(4.4040192E7), (Matcher)CoreMatchers.is((Object)4.728779608739021E16));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toTBs(1.073741824E9), (Matcher)CoreMatchers.is((Object)1.125899906842624E15));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toPBs(1.0), (Matcher)CoreMatchers.is((Object)1024.0));
        MatcherAssert.assertThat((Object)StorageUnit.EB.toEBs(42.0), (Matcher)CoreMatchers.is((Object)42.0));
    }
}

