/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bigtable;

import java.util.Objects;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class BigtableSourceColumn {
    @HopMetadataProperty(key="qualifier")
    private String qualifier;
    @HopMetadataProperty(key="target_type")
    private String targetType;
    @HopMetadataProperty(key="target_field_name")
    private String targetFieldName;

    public BigtableSourceColumn() {
    }

    public BigtableSourceColumn(String qualifier, String targetType, String targetFieldName) {
        this.qualifier = qualifier;
        this.targetType = targetType;
        this.targetFieldName = targetFieldName;
    }

    public IValueMeta getValueMeta() throws HopPluginException {
        int type = ValueMetaFactory.getIdForValueMeta((String)this.targetType);
        String name = Const.NVL((String)this.targetFieldName, (String)this.qualifier);
        return ValueMetaFactory.createValueMeta((String)name, (int)type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigtableSourceColumn that = (BigtableSourceColumn)o;
        return this.qualifier.equals(that.qualifier);
    }

    public int hashCode() {
        return Objects.hash(this.qualifier);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public void setTargetFieldName(String targetFieldName) {
        this.targetFieldName = targetFieldName;
    }
}

