/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.internal.operation.CommandResultDocumentCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.BsonBinaryCodec;
import org.bson.codecs.BsonBooleanCodec;
import org.bson.codecs.BsonDBPointerCodec;
import org.bson.codecs.BsonDateTimeCodec;
import org.bson.codecs.BsonDecimal128Codec;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonDoubleCodec;
import org.bson.codecs.BsonInt32Codec;
import org.bson.codecs.BsonInt64Codec;
import org.bson.codecs.BsonJavaScriptCodec;
import org.bson.codecs.BsonJavaScriptWithScopeCodec;
import org.bson.codecs.BsonMaxKeyCodec;
import org.bson.codecs.BsonMinKeyCodec;
import org.bson.codecs.BsonNullCodec;
import org.bson.codecs.BsonObjectIdCodec;
import org.bson.codecs.BsonRegularExpressionCodec;
import org.bson.codecs.BsonStringCodec;
import org.bson.codecs.BsonSymbolCodec;
import org.bson.codecs.BsonTimestampCodec;
import org.bson.codecs.BsonUndefinedCodec;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec((Codec)new BsonNullCodec());
        this.addCodec((Codec)new BsonBinaryCodec());
        this.addCodec((Codec)new BsonBooleanCodec());
        this.addCodec((Codec)new BsonDateTimeCodec());
        this.addCodec((Codec)new BsonDBPointerCodec());
        this.addCodec((Codec)new BsonDoubleCodec());
        this.addCodec((Codec)new BsonInt32Codec());
        this.addCodec((Codec)new BsonInt64Codec());
        this.addCodec((Codec)new BsonDecimal128Codec());
        this.addCodec((Codec)new BsonMinKeyCodec());
        this.addCodec((Codec)new BsonMaxKeyCodec());
        this.addCodec((Codec)new BsonJavaScriptCodec());
        this.addCodec((Codec)new BsonObjectIdCodec());
        this.addCodec((Codec)new BsonRegularExpressionCodec());
        this.addCodec((Codec)new BsonStringCodec());
        this.addCodec((Codec)new BsonSymbolCodec());
        this.addCodec((Codec)new BsonTimestampCodec());
        this.addCodec((Codec)new BsonUndefinedCodec());
        this.addCodec((Codec)new BsonJavaScriptWithScopeCodec((Codec)new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result = this.payloadDecoder.getClass().hashCode();
        result = 31 * result + this.fieldsContainingPayload.hashCode();
        return result;
    }
}

