/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class FlinkAssignContext<@UnknownKeyFor InputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
extends WindowFn.AssignContext {
    private final @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value;

    FlinkAssignContext(@UnknownKeyFor @NonNull @Initialized WindowFn<InputT, W> fn, @UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> value) {
        super(fn);
        if (Iterables.size((Iterable)value.getWindows()) != 1) {
            throw new IllegalArgumentException(String.format("%s passed to window assignment must be in a single window, but it was in %s: %s", WindowedValues.class.getSimpleName(), Iterables.size((Iterable)value.getWindows()), value.getWindows()));
        }
        this.value = value;
    }

    public InputT element() {
        return (InputT)this.value.getValue();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant timestamp() {
        return this.value.getTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
        return (BoundedWindow)Iterables.getOnlyElement((Iterable)this.value.getWindows());
    }
}

